/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class ForgeMetrics {
    private static final int REVISION = 6;
    private static final String BASE_URL = "http://mcstats.org";
    private static final String REPORT_URL = "/report/%s";
    private static final String CUSTOM_DATA_SEPARATOR = "~~";
    private static final int PING_INTERVAL = 10;
    private final String modname;
    private final String modversion;
    private final Set<Graph> graphs = Collections.synchronizedSet(new HashSet());
    private final Graph defaultGraph = new Graph("Default");
    private final Configuration configuration;
    private final File configurationFile;
    private final String guid;
    private final boolean debug;
    private volatile IScheduledTickHandler task = null;
    private boolean stopped = false;

    public ForgeMetrics(String modname, String modversion) throws IOException {
        if (modname == null || modversion == null) {
            throw new IllegalArgumentException("modname and modversion cannot be null");
        }
        this.modname = modname;
        this.modversion = modversion;
        this.configurationFile = this.getConfigFile();
        this.configuration = new Configuration(this.configurationFile);
        this.configuration.get("general", "opt-out", false, "Set to true to disable all reporting");
        this.guid = this.configuration.get("general", "guid", UUID.randomUUID().toString(), "Server unique ID").getString();
        this.debug = this.configuration.get("general", "debug", false, "Set to true for verbose debug").getBoolean(false);
        this.configuration.save();
    }

    public Graph createGraph(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Graph name cannot be null");
        }
        Graph graph = new Graph(name);
        this.graphs.add(graph);
        return graph;
    }

    public void addGraph(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph cannot be null");
        }
        this.graphs.add(graph);
    }

    public void addCustomData(Plotter plotter) {
        if (plotter == null) {
            throw new IllegalArgumentException("Plotter cannot be null");
        }
        this.defaultGraph.addPlotter(plotter);
        this.graphs.add(this.defaultGraph);
    }

    public boolean start() {
        if (this.isOptOut()) {
            return false;
        }
        this.stopped = false;
        if (this.task != null) {
            return true;
        }
        this.task = new IScheduledTickHandler(){
            private boolean firstPost = true;
            private Thread thrd = null;

            public void tickStart(EnumSet<TickType> type, Object ... tickData) {
            }

            public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
                if (ForgeMetrics.this.stopped) {
                    return;
                }
                if (ForgeMetrics.this.isOptOut()) {
                    for (Graph graph : ForgeMetrics.this.graphs) {
                        graph.onOptOut();
                    }
                    ForgeMetrics.this.stopped = true;
                    return;
                }
                if (this.thrd == null) {
                    this.thrd = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ForgeMetrics.this.postPlugin(!firstPost);
                                firstPost = false;
                            }
                            catch (IOException e) {
                                if (ForgeMetrics.this.debug) {
                                    FMLLog.info((String)"[Metrics] Exception - %s", (Object[])new Object[]{e.getMessage()});
                                }
                            }
                            finally {
                                thrd = null;
                            }
                        }
                    });
                    this.thrd.start();
                }
            }

            public EnumSet<TickType> ticks() {
                return EnumSet.of(TickType.SERVER);
            }

            public String getLabel() {
                return ForgeMetrics.this.modname + " Metrics";
            }

            public int nextTickSpacing() {
                if (this.firstPost) {
                    return 100;
                }
                return 12000;
            }
        };
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)this.task, (Side)Side.SERVER);
        return true;
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isOptOut() {
        this.configuration.load();
        return this.configuration.get("general", "opt-out", false).getBoolean(false);
    }

    public void enable() throws IOException {
        if (this.isOptOut()) {
            this.configuration.getCategory("general").put("opt-out", new Property("opt-out", "false", Property.Type.BOOLEAN));
            this.configuration.save();
        }
        if (this.task == null) {
            this.start();
        }
    }

    public void disable() throws IOException {
        if (!this.isOptOut()) {
            this.configuration.getCategory("general").put("opt-out", new Property("opt-out", "true", Property.Type.BOOLEAN));
            this.configuration.save();
        }
    }

    public File getConfigFile() {
        return new File(Loader.instance().getConfigDir(), "PluginMetrics.cfg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPlugin(boolean isPing) throws IOException {
        String pluginName = this.modname;
        boolean onlineMode = MinecraftServer.func_71276_C().func_71266_T();
        String pluginVersion = this.modversion;
        String serverVersion = MinecraftServer.func_71276_C().func_71262_S() ? "MinecraftForge (MC: " + MinecraftServer.func_71276_C().func_71249_w() + ")" : "MinecraftForgeSSP (MC: " + MinecraftServer.func_71276_C().func_71249_w() + ")";
        int playersOnline = MinecraftServer.func_71276_C().func_71233_x();
        StringBuilder data = new StringBuilder();
        data.append(ForgeMetrics.encode("guid")).append('=').append(ForgeMetrics.encode(this.guid));
        ForgeMetrics.encodeDataPair(data, "version", pluginVersion);
        ForgeMetrics.encodeDataPair(data, "server", serverVersion);
        ForgeMetrics.encodeDataPair(data, "players", Integer.toString(playersOnline));
        ForgeMetrics.encodeDataPair(data, "revision", String.valueOf(6));
        String osname = System.getProperty("os.name");
        String osarch = System.getProperty("os.arch");
        String osversion = System.getProperty("os.version");
        String java_version = System.getProperty("java.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        if (osarch.equals("amd64")) {
            osarch = "x86_64";
        }
        ForgeMetrics.encodeDataPair(data, "osname", osname);
        ForgeMetrics.encodeDataPair(data, "osarch", osarch);
        ForgeMetrics.encodeDataPair(data, "osversion", osversion);
        ForgeMetrics.encodeDataPair(data, "cores", Integer.toString(coreCount));
        ForgeMetrics.encodeDataPair(data, "online-mode", Boolean.toString(onlineMode));
        ForgeMetrics.encodeDataPair(data, "java_version", java_version);
        if (isPing) {
            ForgeMetrics.encodeDataPair(data, "ping", "true");
        }
        Set<Graph> set = this.graphs;
        synchronized (set) {
            for (Graph graph : this.graphs) {
                for (Plotter plotter : graph.getPlotters()) {
                    String key = String.format("C%s%s%s%s", CUSTOM_DATA_SEPARATOR, graph.getName(), CUSTOM_DATA_SEPARATOR, plotter.getColumnName());
                    String value = Integer.toString(plotter.getValue());
                    ForgeMetrics.encodeDataPair(data, key, value);
                }
            }
        }
        URL url = new URL(BASE_URL + String.format(REPORT_URL, ForgeMetrics.encode(pluginName)));
        URLConnection connection = this.isMineshafterPresent() ? url.openConnection(Proxy.NO_PROXY) : url.openConnection();
        connection.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(data.toString());
        writer.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = reader.readLine();
        writer.close();
        reader.close();
        if (response == null || response.startsWith("ERR")) {
            throw new IOException(response);
        }
        if (response.contains("OK This is your first update this hour")) {
            Set<Graph> set2 = this.graphs;
            synchronized (set2) {
                for (Graph graph : this.graphs) {
                    for (Plotter plotter : graph.getPlotters()) {
                        plotter.reset();
                    }
                }
            }
        }
    }

    private boolean isMineshafterPresent() {
        try {
            Class.forName("mineshafter.MineServer");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void encodeDataPair(StringBuilder buffer, String key, String value) throws UnsupportedEncodingException {
        buffer.append('&').append(ForgeMetrics.encode(key)).append('=').append(ForgeMetrics.encode(value));
    }

    private static String encode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, "UTF-8");
    }

    public static abstract class Plotter {
        private final String name;

        public Plotter() {
            this("Default");
        }

        public Plotter(String name) {
            this.name = name;
        }

        public abstract int getValue();

        public String getColumnName() {
            return this.name;
        }

        public void reset() {
        }

        public int hashCode() {
            return this.getColumnName().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Plotter)) {
                return false;
            }
            Plotter plotter = (Plotter)object;
            return plotter.name.equals(this.name) && plotter.getValue() == this.getValue();
        }
    }

    public static class Graph {
        private final String name;
        private final Set<Plotter> plotters = new LinkedHashSet<Plotter>();

        private Graph(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addPlotter(Plotter plotter) {
            this.plotters.add(plotter);
        }

        public void removePlotter(Plotter plotter) {
            this.plotters.remove(plotter);
        }

        public Set<Plotter> getPlotters() {
            return Collections.unmodifiableSet(this.plotters);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Graph)) {
                return false;
            }
            Graph graph = (Graph)object;
            return graph.name.equals(this.name);
        }

        protected void onOptOut() {
        }
    }
}

