/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.MapType;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.debug.Debug;
import org.dynmap.utils.DynmapBufferedImage;
import org.dynmap.utils.FileLockManager;

public class PlayerFaces {
    private File facesdir;
    private File faces8x8dir;
    private File faces16x16dir;
    private File faces32x32dir;
    private File body32x32dir;
    private boolean fetchskins;
    private boolean refreshskins;
    private String skinurl;

    public PlayerFaces(DynmapCore core) {
        this.fetchskins = core.configuration.getBoolean("fetchskins", true);
        this.refreshskins = core.configuration.getBoolean("refreshskins", true);
        this.skinurl = core.configuration.getString("skin-url", "http://s3.amazonaws.com/MinecraftSkins/%player%.png");
        core.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_JOIN, new DynmapListenerManager.PlayerEventListener(){

            @Override
            public void playerEvent(DynmapPlayer p) {
                LoadPlayerImages job = new LoadPlayerImages(p.getName());
                if (PlayerFaces.this.fetchskins) {
                    MapManager.scheduleDelayedJob(job, 0L);
                } else {
                    job.run();
                }
            }
        });
        this.facesdir = new File(core.getTilesFolder(), "faces");
        this.facesdir.mkdirs();
        this.faces8x8dir = new File(this.facesdir, "8x8");
        this.faces8x8dir.mkdirs();
        this.faces16x16dir = new File(this.facesdir, "16x16");
        this.faces16x16dir.mkdirs();
        this.faces32x32dir = new File(this.facesdir, "32x32");
        this.faces32x32dir.mkdirs();
        this.body32x32dir = new File(this.facesdir, "body");
        this.body32x32dir.mkdirs();
    }

    private class LoadPlayerImages
    implements Runnable {
        public String playername;

        public LoadPlayerImages(String playername) {
            this.playername = playername;
        }

        @Override
        public void run() {
            int j;
            int i;
            File img_8x8 = new File(PlayerFaces.this.faces8x8dir, this.playername + ".png");
            File img_16x16 = new File(PlayerFaces.this.faces16x16dir, this.playername + ".png");
            File img_32x32 = new File(PlayerFaces.this.faces32x32dir, this.playername + ".png");
            File body = new File(PlayerFaces.this.body32x32dir, this.playername + ".png");
            boolean has_8x8 = img_8x8.exists();
            boolean has_16x16 = img_16x16.exists();
            boolean has_32x32 = img_32x32.exists();
            boolean has_body = body.exists();
            boolean missing_any = !has_8x8 || !has_16x16 || !has_32x32 || !has_body;
            BufferedImage img = null;
            try {
                if (PlayerFaces.this.fetchskins && (PlayerFaces.this.refreshskins || missing_any)) {
                    URL url = new URL(PlayerFaces.this.skinurl.replace("%player%", this.playername));
                    img = ImageIO.read(url);
                }
            }
            catch (IOException iox) {
                Debug.debug("Error loading skin for '" + this.playername + "' - " + iox);
            }
            if (img == null) {
                try {
                    InputStream in = this.getClass().getResourceAsStream("/char.png");
                    img = ImageIO.read(in);
                    in.close();
                }
                catch (IOException iox) {
                    Debug.debug("Error loading default skin for '" + this.playername + "' - " + iox);
                }
            }
            if (img == null) {
                return;
            }
            if (img.getWidth() < 64 || img.getHeight() < 32) {
                img.flush();
                return;
            }
            int[] faceaccessory = new int[64];
            DynmapBufferedImage face8x8 = DynmapBufferedImage.allocateBufferedImage(8, 8);
            img.getRGB(8, 8, 8, 8, face8x8.argb_buf, 0, 8);
            img.getRGB(40, 8, 8, 8, faceaccessory, 0, 8);
            boolean transp = false;
            int v = faceaccessory[0];
            for (i = 0; i < 64; ++i) {
                if ((faceaccessory[i] & 0xFF000000) == 0) {
                    transp = true;
                    break;
                }
                if (faceaccessory[i] == v) continue;
                transp = true;
                break;
            }
            if (transp) {
                for (i = 0; i < 64; ++i) {
                    if ((faceaccessory[i] & 0xFF000000) == 0) continue;
                    face8x8.argb_buf[i] = faceaccessory[i];
                }
            }
            if (PlayerFaces.this.refreshskins || !has_8x8) {
                FileLockManager.getWriteLock(img_8x8);
                try {
                    FileLockManager.imageIOWrite(face8x8.buf_img, MapType.ImageFormat.FORMAT_PNG, img_8x8);
                }
                catch (IOException iox) {
                    Log.severe("Cannot write player icon " + img_8x8.getPath());
                }
                FileLockManager.releaseWriteLock(img_8x8);
            }
            if (PlayerFaces.this.refreshskins || !has_16x16) {
                DynmapBufferedImage face16x16 = DynmapBufferedImage.allocateBufferedImage(16, 16);
                for (int i2 = 0; i2 < 16; ++i2) {
                    for (j = 0; j < 16; ++j) {
                        face16x16.argb_buf[i2 * 16 + j] = face8x8.argb_buf[i2 / 2 * 8 + j / 2];
                    }
                }
                FileLockManager.getWriteLock(img_16x16);
                try {
                    FileLockManager.imageIOWrite(face16x16.buf_img, MapType.ImageFormat.FORMAT_PNG, img_16x16);
                }
                catch (IOException iox) {
                    Log.severe("Cannot write player icon " + img_16x16.getPath());
                }
                FileLockManager.releaseWriteLock(img_16x16);
                DynmapBufferedImage.freeBufferedImage(face16x16);
            }
            if (PlayerFaces.this.refreshskins || !has_32x32) {
                DynmapBufferedImage face32x32 = DynmapBufferedImage.allocateBufferedImage(32, 32);
                for (int i3 = 0; i3 < 32; ++i3) {
                    for (j = 0; j < 32; ++j) {
                        face32x32.argb_buf[i3 * 32 + j] = face8x8.argb_buf[i3 / 4 * 8 + j / 4];
                    }
                }
                FileLockManager.getWriteLock(img_32x32);
                try {
                    FileLockManager.imageIOWrite(face32x32.buf_img, MapType.ImageFormat.FORMAT_PNG, img_32x32);
                }
                catch (IOException iox) {
                    Log.severe("Cannot write player icon " + img_32x32.getPath());
                }
                FileLockManager.releaseWriteLock(img_32x32);
                DynmapBufferedImage.freeBufferedImage(face32x32);
            }
            if (PlayerFaces.this.refreshskins || !has_body) {
                DynmapBufferedImage body32x32 = DynmapBufferedImage.allocateBufferedImage(32, 32);
                for (int i4 = 0; i4 < 8; ++i4) {
                    for (j = 0; j < 8; ++j) {
                        body32x32.argb_buf[i4 * 32 + j + 12] = face8x8.argb_buf[i4 * 8 + j];
                    }
                }
                img.getRGB(20, 20, 8, 12, body32x32.argb_buf, 268, 32);
                img.getRGB(4, 20, 4, 12, body32x32.argb_buf, 652, 32);
                img.getRGB(4, 20, 4, 12, body32x32.argb_buf, 656, 32);
                img.getRGB(44, 20, 4, 12, body32x32.argb_buf, 264, 32);
                img.getRGB(44, 20, 4, 12, body32x32.argb_buf, 276, 32);
                FileLockManager.getWriteLock(body);
                try {
                    FileLockManager.imageIOWrite(body32x32.buf_img, MapType.ImageFormat.FORMAT_PNG, body);
                }
                catch (IOException iox) {
                    Log.severe("Cannot write player icon " + body.getPath());
                }
                FileLockManager.releaseWriteLock(body);
                DynmapBufferedImage.freeBufferedImage(body32x32);
            }
            DynmapBufferedImage.freeBufferedImage(face8x8);
            img.flush();
        }
    }
}

