/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.util.List;
import org.dynmap.MapType;
import org.dynmap.utils.TileFlags;

public class MapTypeState {
    public static final long DEF_INV_PERIOD = 30L;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public MapType type;
    private Object invTileLock = new Object();
    private TileFlags pendingInvTiles = new TileFlags();
    private TileFlags pendingInvTilesAlt = new TileFlags();
    private TileFlags invTiles = new TileFlags();
    private TileFlags.Iterator invTilesIter = this.invTiles.getIterator();
    private long nextInvTS;
    private long invTSPeriod;

    public MapTypeState(MapType mt) {
        this.type = mt;
        this.invTSPeriod = 30000000000L;
        this.nextInvTS = System.nanoTime() + this.invTSPeriod;
    }

    public void setInvalidatePeriod(long inv_per_in_secs) {
        this.invTSPeriod = inv_per_in_secs * 1000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateTile(int tx, int ty) {
        boolean done;
        Object object = this.invTileLock;
        synchronized (object) {
            done = !this.pendingInvTiles.setFlag(tx, ty, true);
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invalidateTiles(List<TileFlags.TileCoord> coords) {
        int cnt = 0;
        Object object = this.invTileLock;
        synchronized (object) {
            for (TileFlags.TileCoord c : coords) {
                if (this.pendingInvTiles.setFlag(c.x, c.y, true)) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickMapTypeState(long now_nano) {
        if (this.nextInvTS < now_nano) {
            Object object = this.invTileLock;
            synchronized (object) {
                TileFlags tmp = this.pendingInvTilesAlt;
                this.pendingInvTilesAlt = this.pendingInvTiles;
                this.pendingInvTiles = tmp;
                this.invTiles.union(tmp);
                tmp.clear();
                this.nextInvTS = now_nano + this.invTSPeriod;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextInvalidTileCoord(TileFlags.TileCoord coord) {
        boolean match;
        Object object = this.invTileLock;
        synchronized (object) {
            match = this.invTilesIter.next(coord);
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateTile(int tx, int ty) {
        Object object = this.invTileLock;
        synchronized (object) {
            this.invTiles.setFlag(tx, ty, false);
            this.pendingInvTiles.setFlag(tx, ty, false);
            this.pendingInvTilesAlt.setFlag(tx, ty, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvalidTile(int tx, int ty) {
        Object object = this.invTileLock;
        synchronized (object) {
            return this.invTiles.getFlag(tx, ty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> save() {
        Object object = this.invTileLock;
        synchronized (object) {
            this.invTiles.union(this.pendingInvTiles);
            this.invTiles.union(this.pendingInvTilesAlt);
            this.pendingInvTiles.clear();
            this.pendingInvTilesAlt.clear();
            return this.invTiles.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(List<String> saved) {
        Object object = this.invTileLock;
        synchronized (object) {
            TileFlags tf = new TileFlags();
            tf.load(saved);
            this.invTiles.union(tf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInvCount() {
        Object object = this.invTileLock;
        synchronized (object) {
            return this.invTiles.countFlags();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.invTileLock;
        synchronized (object) {
            this.invTiles.clear();
        }
    }
}

