/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapWorld;
import org.dynmap.MapTile;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.utils.TileFlags;

public abstract class MapType {
    private boolean is_protected;
    protected int tileupdatedelay;

    public abstract void addMapTiles(List<MapTile> var1, DynmapWorld var2, int var3, int var4);

    public abstract List<TileFlags.TileCoord> getTileCoords(DynmapWorld var1, int var2, int var3, int var4);

    public abstract List<TileFlags.TileCoord> getTileCoords(DynmapWorld var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract MapTile[] getAdjecentTiles(MapTile var1);

    public abstract List<DynmapChunk> getRequiredChunks(MapTile var1);

    public void buildClientConfiguration(JSONObject worldObject, DynmapWorld w) {
    }

    public List<MapTile> getTiles(DynmapWorld w, int x, int y, int z) {
        List<TileFlags.TileCoord> coords = this.getTileCoords(w, x, y, z);
        ArrayList<MapTile> tiles = new ArrayList<MapTile>();
        for (TileFlags.TileCoord c : coords) {
            this.addMapTiles(tiles, w, c.x, c.y);
        }
        return tiles;
    }

    public abstract String getName();

    public abstract List<MapType> getMapsSharingRender(DynmapWorld var1);

    public abstract List<String> getMapNamesSharingRender(DynmapWorld var1);

    public abstract MapStep zoomFileMapStep();

    public abstract List<ZoomInfo> baseZoomFileInfo();

    public abstract int baseZoomFileStepSize();

    public abstract int getBigWorldShift();

    public abstract boolean isBigWorldMap(DynmapWorld var1);

    public int getMapZoomOutLevels() {
        return 0;
    }

    public ImageFormat getImageFormat() {
        return ImageFormat.FORMAT_PNG;
    }

    public int getBackgroundARGBNight() {
        return 0;
    }

    public int getBackgroundARGBDay() {
        return 0;
    }

    public abstract int[] zoomFileStepSequence();

    public void purgeOldTiles(DynmapWorld world, TileFlags rendered) {
    }

    protected void walkMapTree(File root, FileCallback cb, boolean day) {
        LinkedList<File> dirs = new LinkedList<File>();
        String ext = "." + this.getImageFormat().getFileExt();
        dirs.add(root);
        while (!dirs.isEmpty()) {
            File dir = (File)dirs.pop();
            String[] lst = dir.list();
            if (lst == null) continue;
            for (String fn : lst) {
                if (fn.equals(".") || fn.equals("..")) continue;
                File f = new File(dir, fn);
                if (f.isDirectory()) {
                    dirs.add(f);
                    continue;
                }
                if (!fn.endsWith(ext)) continue;
                cb.fileFound(f, dir, day);
            }
        }
    }

    public ConfigurationNode saveConfiguration() {
        ConfigurationNode cn = new ConfigurationNode();
        cn.put("class", (Object)this.getClass().getName());
        cn.put("name", (Object)this.getName());
        return cn;
    }

    public boolean isProtected() {
        return this.is_protected;
    }

    public boolean setProtected(boolean p) {
        if (this.is_protected != p) {
            this.is_protected = p;
            return true;
        }
        return false;
    }

    public abstract String getPrefix();

    public int getTileUpdateDelay(DynmapWorld w) {
        if (this.tileupdatedelay > 0) {
            return this.tileupdatedelay;
        }
        return w.getTileUpdateDelay();
    }

    public boolean setTileUpdateDelay(int delay) {
        if (this.tileupdatedelay != delay) {
            this.tileupdatedelay = delay;
            return true;
        }
        return false;
    }

    public static interface FileCallback {
        public void fileFound(File var1, File var2, boolean var3);
    }

    public static enum MapStep {
        X_PLUS_Y_PLUS,
        X_PLUS_Y_MINUS,
        X_MINUS_Y_PLUS,
        X_MINUS_Y_MINUS;

    }

    public static class ZoomInfo {
        public String prefix;
        public int background_argb;

        public ZoomInfo(String pre, int bg) {
            this.prefix = pre;
            this.background_argb = bg;
        }
    }

    public static enum ImageFormat {
        FORMAT_PNG("png", "png", 0.0f),
        FORMAT_JPG75("jpg-q75", "jpg", 0.75f),
        FORMAT_JPG80("jpg-q80", "jpg", 0.8f),
        FORMAT_JPG85("jpg-q85", "jpg", 0.85f),
        FORMAT_JPG("jpg", "jpg", 0.85f),
        FORMAT_JPG90("jpg-q90", "jpg", 0.9f),
        FORMAT_JPG95("jpg-q95", "jpg", 0.95f),
        FORMAT_JPG100("jpg-q100", "jpg", 1.0f);

        String id;
        String ext;
        float qual;

        private ImageFormat(String id, String ext, float quality) {
            this.id = id;
            this.ext = ext;
            this.qual = quality;
        }

        public String getID() {
            return this.id;
        }

        public String getFileExt() {
            return this.ext;
        }

        public float getQuality() {
            return this.qual;
        }

        public static ImageFormat fromID(String imgfmt) {
            for (ImageFormat i_f : ImageFormat.values()) {
                if (!i_f.getID().equals(imgfmt)) continue;
                return i_f;
            }
            return null;
        }
    }
}

