/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.Client;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapLocation;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.MapType;
import org.dynmap.MapTypeState;
import org.dynmap.TileHashManager;
import org.dynmap.UpdateQueue;
import org.dynmap.debug.Debug;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.utils.DynmapBufferedImage;
import org.dynmap.utils.FileLockManager;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.RectangleVisibilityLimit;
import org.dynmap.utils.RoundVisibilityLimit;
import org.dynmap.utils.TileFlags;
import org.dynmap.utils.VisibilityLimit;

public abstract class DynmapWorld {
    private static boolean do_init_scan = true;
    public List<MapType> maps = new ArrayList<MapType>();
    public List<MapTypeState> mapstate = new ArrayList<MapTypeState>();
    public UpdateQueue updates = new UpdateQueue();
    public DynmapLocation center;
    public List<DynmapLocation> seedloc;
    private List<DynmapLocation> seedloccfg;
    public List<VisibilityLimit> visibility_limits;
    public List<VisibilityLimit> hidden_limits;
    public MapChunkCache.HiddenChunkStyle hiddenchunkstyle;
    public int servertime;
    public boolean sendposition;
    public boolean sendhealth;
    public boolean bigworld;
    private int extrazoomoutlevels;
    public File worldtilepath;
    private Object lock = new Object();
    private HashSet<String>[] zoomoutupdates = new HashSet[0];
    private boolean checkts = do_init_scan;
    private boolean cancelled;
    private final String wname;
    private final int hashcode;
    private final String raw_wname;
    private String title;
    public int tileupdatedelay;
    private boolean is_enabled;
    boolean is_protected;
    protected int[] brightnessTable = new int[16];
    public final int worldheight;
    public final int heightshift;
    public final int heightmask;
    public final int sealevel;
    private static final String COORDSTART = "-0123456789";

    protected DynmapWorld(String wname, int worldheight, int sealevel) {
        this.raw_wname = wname;
        this.wname = DynmapWorld.normalizeWorldName(wname);
        this.hashcode = this.wname.hashCode();
        this.title = wname;
        this.worldheight = worldheight;
        this.sealevel = sealevel;
        int shift = 0;
        while (1 << shift < worldheight) {
            ++shift;
        }
        this.heightshift = shift;
        this.heightmask = (1 << shift) - 1;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.setBrightnessTableEntry(i, (1.0f - f1) / (f1 * 3.0f + 1.0f));
        }
    }

    protected void setBrightnessTableEntry(int level, float value) {
        if (level < 0 || level > 15) {
            return;
        }
        this.brightnessTable[level] = (int)(256.0 * (double)value);
        if (this.brightnessTable[level] > 256) {
            this.brightnessTable[level] = 256;
        }
        if (this.brightnessTable[level] < 0) {
            this.brightnessTable[level] = 0;
        }
    }

    public int[] getBrightnessTable() {
        return this.brightnessTable;
    }

    public void setExtraZoomOutLevels(int lvl) {
        this.extrazoomoutlevels = lvl;
        this.zoomoutupdates = new HashSet[lvl];
        for (int i = 0; i < lvl; ++i) {
            this.zoomoutupdates[i] = new HashSet();
        }
        this.checkts = do_init_scan;
    }

    public int getExtraZoomOutLevels() {
        return this.extrazoomoutlevels;
    }

    public void enqueueZoomOutUpdate(File f) {
        this.enqueueZoomOutUpdate(f, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueZoomOutUpdate(File f, int level) {
        Object object = this.lock;
        synchronized (object) {
            if (level >= this.zoomoutupdates.length) {
                HashSet[] new_zoomout = new HashSet[level + 1];
                System.arraycopy(this.zoomoutupdates, 0, new_zoomout, 0, this.zoomoutupdates.length);
                for (int i = 0; i < new_zoomout.length; ++i) {
                    new_zoomout[i] = i < this.zoomoutupdates.length ? this.zoomoutupdates[i] : new HashSet();
                }
                this.zoomoutupdates = new_zoomout;
            }
            this.zoomoutupdates[level].add(f.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean popQueuedUpdate(File f, int level) {
        if (level >= this.zoomoutupdates.length) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.zoomoutupdates[level].remove(f.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] peekQueuedUpdates(int level) {
        if (level >= this.zoomoutupdates.length) {
            return new String[0];
        }
        Object object = this.lock;
        synchronized (object) {
            return this.zoomoutupdates[level].toArray(new String[this.zoomoutupdates[level].size()]);
        }
    }

    public void freshenZoomOutFiles() {
        boolean done = false;
        int last_done = 0;
        int i = 0;
        while (!this.cancelled && !done) {
            done = this.freshenZoomOutFilesByLevel(i);
            last_done = i++;
        }
        for (i = last_done; i < this.zoomoutupdates.length; ++i) {
            this.zoomoutupdates[i].clear();
        }
        this.checkts = false;
    }

    public void cancelZoomOutFreshen() {
        this.cancelled = true;
    }

    public void activateZoomOutFreshen() {
        this.cancelled = false;
    }

    public boolean freshenZoomOutFilesByLevel(int zoomlevel) {
        int cnt = 0;
        Debug.debug("freshenZoomOutFiles(" + this.wname + "," + zoomlevel + ")");
        if (!this.worldtilepath.exists()) {
            return true;
        }
        HashMap<String, PrefixData> maptab = this.buildPrefixData(zoomlevel);
        if (this.checkts) {
            DirFilter df = new DirFilter();
            for (String pfx : maptab.keySet()) {
                if (this.cancelled) {
                    return true;
                }
                PrefixData pd = maptab.get(pfx);
                if (pd.isbigmap) {
                    File dname = new File(this.worldtilepath, pfx);
                    String[] subdir = dname.list(df);
                    if (subdir == null) continue;
                    for (String s : subdir) {
                        if (this.cancelled) {
                            return true;
                        }
                        File sdname = new File(dname, s);
                        cnt += this.processZoomDirectory(sdname, pd);
                    }
                    continue;
                }
                cnt += this.processZoomDirectory(this.worldtilepath, maptab.get(pfx));
            }
            Debug.debug("freshenZoomOutFiles(" + this.wname + "," + zoomlevel + ") - done (" + cnt + " updated files)");
        } else {
            String[] paths = this.peekQueuedUpdates(zoomlevel);
            HashMap<String, ProcessTileRec> toprocess = new HashMap<String, ProcessTileRec>();
            for (String p : paths) {
                if (this.cancelled) {
                    return true;
                }
                File f = new File(p);
                for (PrefixData pd : maptab.values()) {
                    String zfpath;
                    if (this.cancelled) {
                        return true;
                    }
                    ProcessTileRec tr = null;
                    if (pd.isbigmap && f.getName().startsWith(pd.fnprefix) && f.getParentFile().getParentFile().getName().equals(pd.baseprefix)) {
                        tr = this.processZoomFile(f, pd);
                    } else if (!pd.isbigmap && f.getName().startsWith(pd.fnprefix)) {
                        tr = this.processZoomFile(f, pd);
                    }
                    if (tr == null || toprocess.containsKey(zfpath = tr.zf.getPath())) continue;
                    toprocess.put(zfpath, tr);
                }
            }
            for (ProcessTileRec s : toprocess.values()) {
                if (this.cancelled) {
                    return true;
                }
                this.processZoomTile(s.pd, s.zf, s.zfname, s.x, s.y);
            }
        }
        return maptab.size() == 0;
    }

    private HashMap<String, PrefixData> buildPrefixData(int zoomlevel) {
        HashMap<String, PrefixData> maptab = new HashMap<String, PrefixData>();
        for (MapType mt : this.maps) {
            if (zoomlevel > this.extrazoomoutlevels + mt.getMapZoomOutLevels()) continue;
            List<MapType.ZoomInfo> pfx = mt.baseZoomFileInfo();
            int stepsize = mt.baseZoomFileStepSize();
            int bigworldshift = mt.getBigWorldShift();
            boolean neg_step_x = false;
            boolean neg_step_y = false;
            switch (mt.zoomFileMapStep()) {
                case X_PLUS_Y_PLUS: {
                    break;
                }
                case X_MINUS_Y_PLUS: {
                    neg_step_x = true;
                    break;
                }
                case X_PLUS_Y_MINUS: {
                    neg_step_y = true;
                    break;
                }
                case X_MINUS_Y_MINUS: {
                    neg_step_y = true;
                    neg_step_x = true;
                }
            }
            int[] stepseq = mt.zoomFileStepSequence();
            for (MapType.ZoomInfo p : pfx) {
                PrefixData pd = new PrefixData();
                pd.stepsize = stepsize;
                pd.neg_step_x = neg_step_x;
                pd.neg_step_y = neg_step_y;
                pd.stepseq = stepseq;
                pd.baseprefix = p.prefix;
                pd.background = p.background_argb;
                pd.zoomlevel = zoomlevel;
                pd.zoomprefix = "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz".substring(0, zoomlevel);
                pd.bigworldshift = bigworldshift;
                pd.isbigmap = mt.isBigWorldMap(this);
                pd.fmt = mt.getImageFormat();
                if (pd.isbigmap) {
                    if (zoomlevel > 0) {
                        pd.zoomprefix = pd.zoomprefix + "_";
                        pd.zfnprefix = "z" + pd.zoomprefix;
                    } else {
                        pd.zfnprefix = "z_";
                    }
                    pd.fnprefix = pd.zoomprefix;
                } else {
                    pd.fnprefix = pd.zoomprefix + pd.baseprefix;
                    pd.zfnprefix = "z" + pd.fnprefix;
                }
                maptab.put(p.prefix, pd);
            }
        }
        return maptab;
    }

    private String makeFilePath(PrefixData pd, int x, int y, boolean zoomed) {
        if (pd.isbigmap) {
            return pd.baseprefix + "/" + (x >> pd.bigworldshift) + "_" + (y >> pd.bigworldshift) + "/" + (zoomed ? pd.zfnprefix : pd.fnprefix) + x + "_" + y + "." + pd.fmt.getFileExt();
        }
        return (zoomed ? pd.zfnprefix : pd.fnprefix) + "_" + x + "_" + y + "." + pd.fmt.getFileExt();
    }

    private int processZoomDirectory(File dir, PrefixData pd) {
        HashMap<String, ProcessTileRec> toprocess = new HashMap<String, ProcessTileRec>();
        String[] files = dir.list(new PNGFileFilter(pd.fnprefix, pd.fmt));
        if (files == null) {
            return 0;
        }
        for (String fn : files) {
            String zfpath;
            ProcessTileRec tr = this.processZoomFile(new File(dir, fn), pd);
            if (tr == null || toprocess.containsKey(zfpath = tr.zf.getPath())) continue;
            toprocess.put(zfpath, tr);
        }
        int cnt = 0;
        for (ProcessTileRec s : toprocess.values()) {
            this.processZoomTile(s.pd, s.zf, s.zfname, s.x, s.y);
            ++cnt;
        }
        return cnt;
    }

    private ProcessTileRec processZoomFile(File f, PrefixData pd) {
        if (!this.checkts && !this.popQueuedUpdate(f, pd.zoomlevel)) {
            return null;
        }
        int step = pd.stepsize << pd.zoomlevel;
        String fn = f.getName();
        fn = fn.substring(0, fn.lastIndexOf(46));
        String[] tok = fn.split("_");
        int x = 0;
        int y = 0;
        boolean parsed = false;
        if (tok.length >= 2) {
            try {
                x = Integer.parseInt(tok[tok.length - 2]);
                y = Integer.parseInt(tok[tok.length - 1]);
                parsed = true;
            }
            catch (NumberFormatException nfx) {
                // empty catch block
            }
        }
        if (!parsed) {
            return null;
        }
        if (pd.neg_step_x) {
            x = -x;
        }
        x = x >= 0 ? (x -= x % (2 * step)) : (x += x % (2 * step));
        if (pd.neg_step_x) {
            x = -x;
        }
        if (pd.neg_step_y) {
            y = -y;
        }
        y = y >= 0 ? (y -= y % (2 * step)) : (y += y % (2 * step));
        if (pd.neg_step_y) {
            y = -y;
        }
        String zfname = this.makeFilePath(pd, x, y, true);
        File zf = new File(this.worldtilepath, zfname);
        if (this.checkts && !this.popQueuedUpdate(f, pd.zoomlevel) && zf.exists() && zf.lastModified() >= f.lastModified()) {
            return null;
        }
        ProcessTileRec rec = new ProcessTileRec();
        rec.zf = zf;
        rec.x = x;
        rec.y = y;
        rec.zfname = zfname;
        rec.pd = pd;
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processZoomTile(PrefixData pd, File zf, String zfname, int tx, int ty) {
        block28: {
            int width = 128;
            int height = 128;
            BufferedImage zIm = null;
            DynmapBufferedImage kzIm = null;
            boolean blank = true;
            int[] argb = new int[width * height];
            int step = pd.stepsize << pd.zoomlevel;
            int ztx = tx;
            int zty = ty;
            tx -= pd.neg_step_x ? step : 0;
            ty -= pd.neg_step_y ? step : 0;
            kzIm = DynmapBufferedImage.allocateBufferedImage(width, height);
            zIm = kzIm.buf_img;
            for (int i = 0; i < 4; ++i) {
                boolean doblit;
                block27: {
                    doblit = true;
                    File f = new File(this.worldtilepath, this.makeFilePath(pd, tx + step * (1 & pd.stepseq[i]), ty + step * (pd.stepseq[i] >> 1), false));
                    FileLockManager.getReadLock(f);
                    try {
                        if (f.exists()) {
                            BufferedImage im = null;
                            this.popQueuedUpdate(f, pd.zoomlevel);
                            try {
                                im = FileLockManager.imageIORead(f);
                            }
                            catch (IOException iox) {
                                Log.warning("Aborted zoom tile update " + zf.getPath());
                                FileLockManager.releaseReadLock(f);
                                return;
                            }
                            if (im != null && im.getWidth() >= width && im.getHeight() >= height) {
                                int iheight;
                                int iwidth = im.getWidth();
                                if (iwidth > (iheight = im.getHeight())) {
                                    iwidth = iheight;
                                }
                                if (iwidth == width && iheight == height) {
                                    im.getRGB(0, 0, width, height, argb, 0, width);
                                    im.flush();
                                    int off = 0;
                                    for (int y = 0; y < height; y += 2) {
                                        off = y * width;
                                        int x = 0;
                                        while (x < width) {
                                            int p0 = argb[off];
                                            int p1 = argb[off + 1];
                                            int p2 = argb[off + width];
                                            int p3 = argb[off + width + 1];
                                            int alpha = (p0 >> 24 & 0xFF) + (p1 >> 24 & 0xFF) + (p2 >> 24 & 0xFF) + (p3 >> 24 & 0xFF);
                                            int red = (p0 >> 16 & 0xFF) + (p1 >> 16 & 0xFF) + (p2 >> 16 & 0xFF) + (p3 >> 16 & 0xFF);
                                            int green = (p0 >> 8 & 0xFF) + (p1 >> 8 & 0xFF) + (p2 >> 8 & 0xFF) + (p3 >> 8 & 0xFF);
                                            int blue = (p0 & 0xFF) + (p1 & 0xFF) + (p2 & 0xFF) + (p3 & 0xFF);
                                            argb[off >> 1] = (alpha >> 2 & 0xFF) << 24 | (red >> 2 & 0xFF) << 16 | (green >> 2 & 0xFF) << 8 | blue >> 2 & 0xFF;
                                            x += 2;
                                            off += 2;
                                        }
                                    }
                                } else {
                                    int[] buf = new int[iwidth * iwidth];
                                    im.getRGB(0, 0, iwidth, iwidth, buf, 0, iwidth);
                                    im.flush();
                                    TexturePack.scaleTerrainPNGSubImage(iwidth, width / 2, buf, argb);
                                    zIm.setRGB(i >> 1 != 0 ? 0 : width / 2, (i & 1) * height / 2, width / 2, height / 2, argb, 0, width / 2);
                                    doblit = false;
                                }
                                blank = false;
                            } else {
                                if (im != null) {
                                    im.flush();
                                }
                                Arrays.fill(argb, pd.background);
                                f.delete();
                            }
                            break block27;
                        }
                        Arrays.fill(argb, pd.background);
                    }
                    finally {
                        FileLockManager.releaseReadLock(f);
                    }
                }
                if (!doblit) continue;
                zIm.setRGB(i >> 1 != 0 ? 0 : width / 2, (i & 1) * height / 2, width / 2, height / 2, argb, 0, width);
            }
            FileLockManager.getWriteLock(zf);
            try {
                MapManager mm = MapManager.mapman;
                if (mm == null) {
                    return;
                }
                TileHashManager hashman = mm.hashman;
                long crc = hashman.calculateTileHash(kzIm.argb_buf);
                int tilex = ztx / step / 2;
                int tiley = zty / step / 2;
                String key = this.wname + ".z" + pd.zoomprefix + pd.baseprefix;
                if (blank) {
                    if (zf.exists()) {
                        zf.delete();
                        hashman.updateHashCode(key, null, tilex, tiley, -1L);
                        MapManager.mapman.pushUpdate(this, (Client.Update)new Client.Tile(zfname));
                        this.enqueueZoomOutUpdate(zf, pd.zoomlevel + 1);
                    }
                    break block28;
                }
                if (zf.exists() && crc == mm.hashman.getImageHashCode(key, null, tilex, tiley)) break block28;
                try {
                    if (!zf.getParentFile().exists()) {
                        zf.getParentFile().mkdirs();
                    }
                    FileLockManager.imageIOWrite(zIm, pd.fmt, zf);
                }
                catch (IOException e) {
                    Debug.error("Failed to save zoom-out tile: " + zf.getName(), e);
                }
                catch (NullPointerException e) {
                    Debug.error("Failed to save zoom-out tile (NullPointerException): " + zf.getName(), e);
                }
                hashman.updateHashCode(key, null, tilex, tiley, crc);
                MapManager.mapman.pushUpdate(this, (Client.Update)new Client.Tile(zfname));
                this.enqueueZoomOutUpdate(zf, pd.zoomlevel + 1);
            }
            finally {
                FileLockManager.releaseWriteLock(zf);
                DynmapBufferedImage.freeBufferedImage(kzIm);
            }
        }
    }

    public String getName() {
        return this.wname;
    }

    public abstract boolean isNether();

    public abstract DynmapLocation getSpawnLocation();

    public int hashCode() {
        return this.hashcode;
    }

    public abstract long getTime();

    public abstract boolean hasStorm();

    public abstract boolean isThundering();

    public abstract boolean isLoaded();

    public abstract void setWorldUnloaded();

    public abstract int getLightLevel(int var1, int var2, int var3);

    public abstract int getHighestBlockYAt(int var1, int var2);

    public abstract boolean canGetSkyLightLevel();

    public abstract int getSkyLightLevel(int var1, int var2, int var3);

    public abstract String getEnvironment();

    public abstract MapChunkCache getChunkCache(List<DynmapChunk> var1);

    public String getTitle() {
        return this.title;
    }

    public DynmapLocation getCenterLocation() {
        if (this.center != null) {
            return this.center;
        }
        return this.getSpawnLocation();
    }

    public boolean loadConfiguration(DynmapCore core, ConfigurationNode worldconfig) {
        String hiddenchunkstyle;
        List<ConfigurationNode> hidelimits;
        List<ConfigurationNode> vislimits;
        this.is_enabled = worldconfig.getBoolean("enabled", false);
        if (!this.is_enabled) {
            return false;
        }
        this.title = worldconfig.getString("title", this.title);
        ConfigurationNode ctr = worldconfig.getNode("center");
        int mid_y = this.worldheight / 2;
        this.center = ctr != null ? new DynmapLocation(this.wname, ctr.getDouble("x", 0.0), ctr.getDouble("y", mid_y), ctr.getDouble("z", 0.0)) : null;
        this.maps.clear();
        Log.verboseinfo("Loading maps of world '" + this.wname + "'...");
        for (MapType map : worldconfig.createInstances("maps", new Class[]{DynmapCore.class}, new Object[]{core})) {
            if (map.getName() == null) continue;
            this.maps.add(map);
        }
        this.mapstate.clear();
        for (MapType map : this.maps) {
            MapTypeState ms = new MapTypeState(map);
            ms.setInvalidatePeriod(map.getTileUpdateDelay(this));
            this.mapstate.add(ms);
        }
        Log.info("Loaded " + this.maps.size() + " maps of world '" + this.wname + "'.");
        List<ConfigurationNode> loclist = worldconfig.getNodes("fullrenderlocations");
        this.seedloc = new ArrayList<DynmapLocation>();
        this.seedloccfg = new ArrayList<DynmapLocation>();
        this.servertime = (int)(this.getTime() % 24000L);
        this.sendposition = worldconfig.getBoolean("sendposition", true);
        this.sendhealth = worldconfig.getBoolean("sendhealth", true);
        this.bigworld = worldconfig.getBoolean("bigworld", false);
        this.is_protected = worldconfig.getBoolean("protected", false);
        this.setExtraZoomOutLevels(worldconfig.getInteger("extrazoomout", 0));
        this.setTileUpdateDelay(worldconfig.getInteger("tileupdatedelay", -1));
        this.worldtilepath = new File(core.getTilesFolder(), this.wname);
        if (loclist != null) {
            for (ConfigurationNode loc : loclist) {
                DynmapLocation lx = new DynmapLocation(this.wname, loc.getDouble("x", 0.0), loc.getDouble("y", mid_y), loc.getDouble("z", 0.0));
                this.seedloc.add(lx);
                this.seedloccfg.add(lx);
            }
        }
        if ((vislimits = worldconfig.getNodes("visibilitylimits")) != null) {
            this.visibility_limits = new ArrayList<VisibilityLimit>();
            for (ConfigurationNode vis : vislimits) {
                VisibilityLimit lim;
                if (vis.containsKey("r")) {
                    int x_center = vis.getInteger("x", 0);
                    int z_center = vis.getInteger("z", 0);
                    int radius = vis.getInteger("r", 0);
                    lim = new RoundVisibilityLimit(x_center, z_center, radius);
                } else {
                    int x0 = vis.getInteger("x0", 0);
                    int x1 = vis.getInteger("x1", 0);
                    int z0 = vis.getInteger("z0", 0);
                    int z1 = vis.getInteger("z1", 0);
                    lim = new RectangleVisibilityLimit(x0, z0, x1, z1);
                }
                this.visibility_limits.add(lim);
                this.seedloc.add(new DynmapLocation(this.wname, lim.xCenter(), 64.0, lim.zCenter()));
            }
        }
        if ((hidelimits = worldconfig.getNodes("hiddenlimits")) != null) {
            this.hidden_limits = new ArrayList<VisibilityLimit>();
            for (ConfigurationNode vis : hidelimits) {
                VisibilityLimit lim;
                if (vis.containsKey("r")) {
                    int x_center = vis.getInteger("x", 0);
                    int z_center = vis.getInteger("z", 0);
                    int radius = vis.getInteger("r", 0);
                    lim = new RoundVisibilityLimit(x_center, z_center, radius);
                } else {
                    int x0 = vis.getInteger("x0", 0);
                    int x1 = vis.getInteger("x1", 0);
                    int z0 = vis.getInteger("z0", 0);
                    int z1 = vis.getInteger("z1", 0);
                    lim = new RectangleVisibilityLimit(x0, z0, x1, z1);
                }
                this.hidden_limits.add(lim);
            }
        }
        this.hiddenchunkstyle = (hiddenchunkstyle = worldconfig.getString("hidestyle", "stone")).equals("air") ? MapChunkCache.HiddenChunkStyle.FILL_AIR : (hiddenchunkstyle.equals("ocean") ? MapChunkCache.HiddenChunkStyle.FILL_OCEAN : MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN);
        return true;
    }

    public ConfigurationNode saveConfiguration() {
        RoundVisibilityLimit round_lim;
        RectangleVisibilityLimit rect_lim;
        LinkedHashMap<String, Number> lv;
        VisibilityLimit lim;
        ArrayList lims;
        int i;
        ConfigurationNode node = new ConfigurationNode();
        node.put("name", (Object)this.wname);
        node.put("title", (Object)this.getTitle());
        node.put("enabled", (Object)this.is_enabled);
        node.put("protected", (Object)this.is_protected);
        if (this.tileupdatedelay > 0) {
            node.put("tileupdatedelay", (Object)this.tileupdatedelay);
        }
        if (this.center != null) {
            ConfigurationNode c = new ConfigurationNode();
            c.put("x", (Object)this.center.x);
            c.put("y", (Object)this.center.y);
            c.put("z", (Object)this.center.z);
            node.put("center", (Object)c.entries);
        }
        if (this.seedloccfg.size() > 0) {
            ArrayList<Map<String, Object>> locs = new ArrayList<Map<String, Object>>();
            for (i = 0; i < this.seedloccfg.size(); ++i) {
                DynmapLocation dl = this.seedloccfg.get(i);
                ConfigurationNode ll = new ConfigurationNode();
                ll.put("x", (Object)dl.x);
                ll.put("y", (Object)dl.y);
                ll.put("z", (Object)dl.z);
                locs.add(ll.entries);
            }
            node.put("fullrenderlocations", (Object)locs);
        }
        node.put("sendposition", (Object)this.sendposition);
        node.put("sendhealth", (Object)this.sendhealth);
        node.put("bigworld", (Object)this.bigworld);
        node.put("extrazoomout", (Object)this.extrazoomoutlevels);
        if (this.visibility_limits != null) {
            lims = new ArrayList();
            for (i = 0; i < this.visibility_limits.size(); ++i) {
                lim = this.visibility_limits.get(i);
                lv = new LinkedHashMap<String, Number>();
                if (lim instanceof RectangleVisibilityLimit) {
                    rect_lim = (RectangleVisibilityLimit)lim;
                    lv.put("x0", rect_lim.x_min);
                    lv.put("z0", rect_lim.z_min);
                    lv.put("x1", rect_lim.x_max);
                    lv.put("z1", rect_lim.z_max);
                } else {
                    round_lim = (RoundVisibilityLimit)lim;
                    lv.put("x", round_lim.x_center);
                    lv.put("z", round_lim.z_center);
                    lv.put("r", round_lim.radius);
                }
                lims.add(lv);
            }
            node.put("visibilitylimits", (Object)lims);
        }
        if (this.hidden_limits != null) {
            lims = new ArrayList();
            for (i = 0; i < this.hidden_limits.size(); ++i) {
                lim = this.visibility_limits.get(i);
                lv = new LinkedHashMap();
                if (lim instanceof RectangleVisibilityLimit) {
                    rect_lim = (RectangleVisibilityLimit)lim;
                    lv.put("x0", rect_lim.x_min);
                    lv.put("z0", rect_lim.z_min);
                    lv.put("x1", rect_lim.x_max);
                    lv.put("z1", rect_lim.z_max);
                } else {
                    round_lim = (RoundVisibilityLimit)lim;
                    lv.put("x", round_lim.x_center);
                    lv.put("z", round_lim.z_center);
                    lv.put("r", round_lim.radius);
                }
                lims.add(lv);
            }
            node.put("hiddenlimits", (Object)lims);
        }
        String hide = "stone";
        switch (this.hiddenchunkstyle) {
            case FILL_AIR: {
                hide = "air";
                break;
            }
            case FILL_OCEAN: {
                hide = "ocean";
                break;
            }
        }
        node.put("hidestyle", (Object)hide);
        ArrayList<ConfigurationNode> mapinfo = new ArrayList<ConfigurationNode>();
        for (MapType mt : this.maps) {
            ConfigurationNode mnode = mt.saveConfiguration();
            mapinfo.add(mnode);
        }
        node.put("maps", (Object)mapinfo);
        return node;
    }

    public boolean isEnabled() {
        return this.is_enabled;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static String normalizeWorldName(String n) {
        return n != null ? n.replace('/', '-') : null;
    }

    public String getRawName() {
        return this.raw_wname;
    }

    public boolean isProtected() {
        return this.is_protected;
    }

    public int getTileUpdateDelay() {
        if (this.tileupdatedelay > 0) {
            return this.tileupdatedelay;
        }
        return MapManager.mapman.getDefTileUpdateDelay();
    }

    public void setTileUpdateDelay(int time_sec) {
        this.tileupdatedelay = time_sec;
    }

    public static void doInitialScan(boolean doscan) {
        do_init_scan = doscan;
        if (!doscan) {
            Log.info("Initial zoomout validate cancelled");
        }
    }

    public int getChunkMap(TileFlags map) {
        return -1;
    }

    public MapTypeState getMapState(MapType m) {
        for (int i = 0; i < this.maps.size(); ++i) {
            MapType mt = this.maps.get(i);
            if (mt != m) continue;
            return this.mapstate.get(i);
        }
        return null;
    }

    private void deleteTree(File base) {
        String[] fl = base.list();
        if (fl != null) {
            for (String f : fl) {
                File fn = new File(base, f);
                if (fn.isDirectory()) {
                    this.deleteTree(fn);
                }
                fn.delete();
            }
        }
    }

    public void purgeTree() {
        this.deleteTree(this.worldtilepath);
    }

    private static class ProcessTileRec {
        File zf;
        String zfname;
        int x;
        int y;
        PrefixData pd;

        private ProcessTileRec() {
        }
    }

    private static class PrefixData {
        int stepsize;
        int[] stepseq;
        boolean neg_step_x;
        boolean neg_step_y;
        String baseprefix;
        int zoomlevel;
        int background;
        String zoomprefix;
        String fnprefix;
        String zfnprefix;
        int bigworldshift;
        boolean isbigmap;
        MapType.ImageFormat fmt;

        private PrefixData() {
        }
    }

    private static class PNGFileFilter
    implements FilenameFilter {
        String prefix;
        String suffix;

        public PNGFileFilter(String pre, MapType.ImageFormat fmt) {
            if (pre != null && pre.length() > 0) {
                this.prefix = pre;
            }
            this.suffix = "." + fmt.getFileExt();
        }

        @Override
        public boolean accept(File f, String n) {
            if (n.endsWith(this.suffix)) {
                if (this.prefix != null && !n.startsWith(this.prefix)) {
                    return false;
                }
                if (this.prefix == null && DynmapWorld.COORDSTART.indexOf(n.charAt(0)) < 0) {
                    return false;
                }
                File fn = new File(f, n);
                return fn.isFile();
            }
            return false;
        }
    }

    private static class DirFilter
    implements FilenameFilter {
        private DirFilter() {
        }

        @Override
        public boolean accept(File f, String n) {
            if (!n.equals("..") && !n.equals(".")) {
                File fn = new File(f, n);
                return fn.isDirectory();
            }
            return false;
        }
    }
}

