/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.IOException;
import java.io.Writer;
import java.util.Random;
import org.dynmap.ClientUpdateComponent;
import org.dynmap.common.DynmapChatColor;
import org.dynmap.json.simple.JSONAware;
import org.dynmap.json.simple.JSONStreamAware;
import org.dynmap.web.Json;

public class Client {
    private static String[][] codes = new String[][]{{"0", "<span style='color:#000000'>"}, {"1", "<span style='color:#0000AA'>"}, {"2", "<span style='color:#00AA00'>"}, {"3", "<span style='color:#00AAAA'>"}, {"4", "<span style='color:#AA0000'>"}, {"5", "<span style='color:#AA00AA'>"}, {"6", "<span style='color:#FFAA00'>"}, {"7", "<span style='color:#AAAAAA'>"}, {"8", "<span style='color:#555555'>"}, {"9", "<span style='color:#5555FF'>"}, {"a", "<span style='color:#55FF55'>"}, {"b", "<span style='color:#55FFFF'>"}, {"c", "<span style='color:#FF5555'>"}, {"d", "<span style='color:#FF55FF'>"}, {"e", "<span style='color:#FFFF55'>"}, {"f", "<span style='color:#FFFFFF'>"}, {"l", "<span style='font-weight:bold'>"}, {"m", "<span style='text-decoration:line-through'>"}, {"n", "<span style='text-decoration:underline'>"}, {"o", "<span style='font-style:italic'>"}, {"r", "<span style='font-style:normal,text-decoration:none,font-weight:normal'>"}};
    private static Random rnd = new Random();
    private static String rndchars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static String stripColor(String s) {
        s = DynmapChatColor.stripColor(s);
        int idx = 0;
        while ((idx = s.indexOf(38, idx)) >= 0) {
            char c = s.charAt(idx + 1);
            s = c == '&' ? s.substring(0, idx) + s.substring(idx + 1) : s.substring(0, idx) + s.substring(idx + 2);
            ++idx;
        }
        return s;
    }

    public static String encodeColorInHTML(String s) {
        int i;
        StringBuilder sb = new StringBuilder();
        int cnt = s.length();
        int spancnt = 0;
        boolean magic = false;
        block0: for (i = 0; i < cnt; ++i) {
            int j;
            char c = s.charAt(i);
            if (c == '\u00a7') {
                if ((c = s.charAt(++i)) == 'k') {
                    magic = true;
                } else if (c == 'r') {
                    magic = false;
                }
                for (j = 0; j < codes.length; ++j) {
                    if (codes[j][0].charAt(0) != c) continue;
                    sb.append(codes[j][1]);
                    ++spancnt;
                    continue block0;
                }
                continue;
            }
            if (c == '&') {
                if ((c = s.charAt(++i)) == '&') {
                    sb.append(c);
                    continue;
                }
                if (c == 'k') {
                    magic = true;
                } else if (c == 'r') {
                    magic = false;
                }
                for (j = 0; j < codes.length; ++j) {
                    if (codes[j][0].charAt(0) != c) continue;
                    sb.append(codes[j][1]);
                    ++spancnt;
                    continue block0;
                }
                continue;
            }
            if (magic) {
                sb.append(rndchars.charAt(rnd.nextInt(rndchars.length())));
                continue;
            }
            sb.append(c);
        }
        for (i = 0; i < spancnt; ++i) {
            sb.append("</span>");
        }
        return sb.toString();
    }

    public static class ComponentMessage
    extends Update {
        public String type = "component";
    }

    public static class DayNight
    extends Update {
        public String type = "daynight";
        public boolean isday;

        public DayNight(boolean isday) {
            this.isday = isday;
        }

        public boolean equals(Object o) {
            return o instanceof DayNight;
        }

        public int hashCode() {
            return 12345;
        }
    }

    public static class Tile
    extends Update {
        public String type = "tile";
        public String name;

        public Tile(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o instanceof Tile) {
                Tile m = (Tile)o;
                return m.name.equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class PlayerQuitMessage
    extends Update {
        public String type = "playerquit";
        public String playerName;
        public String account;

        public PlayerQuitMessage(String playerName, String playeraccount) {
            this.playerName = ClientUpdateComponent.hideNames ? "" : (ClientUpdateComponent.usePlayerColors ? Client.encodeColorInHTML(playerName) : Client.stripColor(playerName));
            this.account = playeraccount;
        }

        public boolean equals(Object o) {
            if (o instanceof PlayerQuitMessage) {
                PlayerQuitMessage m = (PlayerQuitMessage)o;
                return m.playerName.equals(this.playerName);
            }
            return false;
        }

        public int hashCode() {
            return this.account.hashCode();
        }
    }

    public static class PlayerJoinMessage
    extends Update {
        public String type = "playerjoin";
        public String playerName;
        public String account;

        public PlayerJoinMessage(String playerName, String playeraccount) {
            this.playerName = ClientUpdateComponent.hideNames ? "" : (ClientUpdateComponent.usePlayerColors ? Client.encodeColorInHTML(playerName) : Client.stripColor(playerName));
            this.account = playeraccount;
        }

        public boolean equals(Object o) {
            if (o instanceof PlayerJoinMessage) {
                PlayerJoinMessage m = (PlayerJoinMessage)o;
                return m.playerName.equals(this.playerName);
            }
            return false;
        }

        public int hashCode() {
            return this.account.hashCode();
        }
    }

    public static class ChatMessage
    extends Update {
        public String type = "chat";
        public String source;
        public String playerName;
        public String message;
        public String account;
        public String channel;

        public ChatMessage(String source, String channel, String playerName, String message, String playeraccount) {
            this.source = source;
            this.playerName = ClientUpdateComponent.hideNames ? "" : (ClientUpdateComponent.usePlayerColors ? Client.encodeColorInHTML(playerName) : Client.stripColor(playerName));
            this.message = DynmapChatColor.stripColor(message);
            this.account = playeraccount;
            this.channel = channel;
        }

        public boolean equals(Object o) {
            if (o instanceof ChatMessage) {
                ChatMessage m = (ChatMessage)o;
                return m.source.equals(this.source) && m.playerName.equals(this.playerName) && m.message.equals(this.message);
            }
            return false;
        }

        public int hashCode() {
            return this.source.hashCode() ^ this.playerName.hashCode() ^ this.message.hashCode();
        }
    }

    public static class Update
    implements JSONAware,
    JSONStreamAware {
        public long timestamp = System.currentTimeMillis();

        @Override
        public String toJSONString() {
            return Json.stringifyJson(this);
        }

        @Override
        public void writeJSONString(Writer w) throws IOException {
            w.write(this.toJSONString());
        }
    }
}

