/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.research;

import java.util.Collection;
import java.util.LinkedHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;

public class ResearchCategories {
    public static LinkedHashMap researchCategories = new LinkedHashMap();

    public static ResearchCategoryList getResearchList(String key) {
        return (ResearchCategoryList)researchCategories.get(key);
    }

    public static String getCategoryName(String key) {
        return StatCollector.func_74838_a((String)("tc.research_category." + key));
    }

    public static ResearchItem getResearch(String key) {
        Collection rc = researchCategories.values();
        for (Object cat : rc) {
            Collection rl = ((ResearchCategoryList)cat).research.values();
            for (Object ri : rl) {
                if (!((ResearchItem)ri).key.equals(key)) continue;
                return (ResearchItem)ri;
            }
        }
        return null;
    }

    public static void registerCategory(String key, ResourceLocation icon, ResourceLocation background) {
        if (ResearchCategories.getResearchList(key) == null) {
            ResearchCategoryList rl = new ResearchCategoryList(icon, background);
            researchCategories.put(key, rl);
        }
    }

    public static void addResearch(ResearchItem ri) {
        ResearchCategoryList rl = ResearchCategories.getResearchList(ri.category);
        if (rl != null && !rl.research.containsKey(ri.key)) {
            rl.research.put(ri.key, ri);
            if (ri.displayColumn < rl.minDisplayColumn) {
                rl.minDisplayColumn = ri.displayColumn;
            }
            if (ri.displayRow < rl.minDisplayRow) {
                rl.minDisplayRow = ri.displayRow;
            }
            if (ri.displayColumn > rl.maxDisplayColumn) {
                rl.maxDisplayColumn = ri.displayColumn;
            }
            if (ri.displayRow > rl.maxDisplayRow) {
                rl.maxDisplayRow = ri.displayRow;
            }
        }
    }
}

