/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.sounds;

import java.util.HashMap;
import java.util.Map;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.aesthetics.wall.BlockRailcraftWall;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallAlpha;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallBeta;
import net.minecraft.block.Block;
import net.minecraft.block.StepSound;

public class SoundRegistry {
    private static final Map customSounds = new HashMap();

    public static StepSound getSound(int blockID, int meta) {
        Map blockSounds = (Map)customSounds.get(blockID);
        if (blockSounds != null) {
            return (StepSound)blockSounds.get(meta);
        }
        return null;
    }

    public static void setupBlockSounds() {
        Object block = RailcraftBlocks.getBlockPost();
        if (block != null) {
            SoundRegistry.registerCustomStepSound(block.field_71990_ca, EnumPost.WOOD.ordinal(), Block.field_71967_e);
            SoundRegistry.registerCustomStepSound(block.field_71990_ca, EnumPost.STONE.ordinal(), Block.field_71976_h);
            SoundRegistry.registerCustomStepSound(block.field_71990_ca, EnumPost.METAL.ordinal(), Block.field_71977_i);
        }
        if ((block = BlockCube.getBlock()) != null) {
            for (Enum enum_ : EnumCube.VALUES) {
                SoundRegistry.registerCustomStepSound(block.field_71990_ca, enum_.ordinal(), Block.field_71976_h);
            }
            SoundRegistry.registerCustomStepSound(block.field_71990_ca, EnumCube.STEEL_BLOCK.ordinal(), Block.field_71977_i);
            SoundRegistry.registerCustomStepSound(block.field_71990_ca, EnumCube.CRUSHED_OBSIDIAN.ordinal(), Block.field_71964_f);
            SoundRegistry.registerCustomStepSound(block.field_71990_ca, EnumCube.CREOSOTE_BLOCK.ordinal(), Block.field_71967_e);
        }
        if ((block = BlockRailcraftWall.getBlockAlpha()) != null) {
            for (Enum enum_ : EnumWallAlpha.VALUES) {
                SoundRegistry.registerCustomStepSound(block.field_71990_ca, enum_.ordinal(), Block.field_71976_h);
            }
            SoundRegistry.registerCustomStepSound(block.field_71990_ca, EnumWallAlpha.ICE.ordinal(), Block.field_71974_j);
            SoundRegistry.registerCustomStepSound(block.field_71990_ca, EnumWallAlpha.SNOW.ordinal(), Block.field_82509_m);
        }
        if ((block = BlockRailcraftWall.getBlockBeta()) != null) {
            for (Enum enum_ : EnumWallBeta.VALUES) {
                SoundRegistry.registerCustomStepSound(block.field_71990_ca, enum_.ordinal(), Block.field_71976_h);
            }
        }
    }

    private static void registerCustomStepSound(int blockID, int metadata, StepSound sound) {
        HashMap<Integer, StepSound> blockSounds = (HashMap<Integer, StepSound>)customSounds.get(blockID);
        if (blockSounds == null) {
            blockSounds = new HashMap<Integer, StepSound>();
            customSounds.put(blockID, blockSounds);
        }
        blockSounds.put(metadata, sound);
    }
}

