/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.sounds;

import java.util.HashMap;
import java.util.Map;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.sounds.SoundRegistry;
import net.minecraft.block.StepSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class SoundHelper {
    public static final String SOUND_LOCOMOTIVE_STEAM_WHISTLE = "railcraft:locomotive.steam.whistle";
    public static final String SOUND_STEAM_BURST = "railcraft:machine.steamburst";
    public static final String SOUND_STEAM_HISS = "railcraft:machine.steamhiss";
    private static final Map soundLimiter = new HashMap();

    private static boolean canPlaySound(String name) {
        if (!RailcraftConfig.playSounds()) {
            return false;
        }
        Integer limit = (Integer)soundLimiter.get(name);
        return limit == null || limit <= 10;
    }

    private static void incrementLimiter(String name) {
        Integer limit = (Integer)soundLimiter.get(name);
        if (limit == null) {
            limit = 0;
        }
        Integer n = limit;
        Integer n2 = limit = Integer.valueOf(limit + 1);
        soundLimiter.put(name, limit);
    }

    public static void decrementLimiters() {
        for (Map.Entry entry : soundLimiter.entrySet()) {
            Integer limit = (Integer)entry.getValue();
            if (limit <= 0) continue;
            Integer n = limit;
            Integer n2 = limit = Integer.valueOf(limit - 1);
            entry.setValue(limit);
        }
    }

    public static void playSound(World world, int x, int y, int z, String name, float volume, float pitch) {
        if (SoundHelper.canPlaySound(name)) {
            SoundHelper.incrementLimiter(name);
            world.func_72908_a((double)x, (double)y, (double)z, name, volume, pitch);
        }
    }

    public static void playSoundClient(World world, int x, int y, int z, String name, float volume, float pitch) {
        if (SoundHelper.canPlaySound(name)) {
            SoundHelper.incrementLimiter(name);
            world.func_72980_b((double)x, (double)y, (double)z, name, volume, pitch, false);
        }
    }

    public static void playSoundAtEntity(Entity entity, String name, float volume, float pitch) {
        if (SoundHelper.canPlaySound(name)) {
            SoundHelper.incrementLimiter(name);
            entity.field_70170_p.func_72956_a(entity, name, volume, pitch);
        }
    }

    public static void playBlockSound(World world, int x, int y, int z, String soundName, float volume, float pitch, int blockID, int meta) {
        if (world != null && soundName != null) {
            StepSound sound;
            if (soundName.contains("railcraft") && (sound = SoundRegistry.getSound(blockID, meta)) != null) {
                String newName = soundName.contains("dig") ? sound.func_72676_a() : (soundName.contains("step") ? sound.func_72675_d() : sound.func_82593_b());
                world.func_72908_a((double)x, (double)y, (double)z, newName, volume, pitch * sound.func_72678_c());
            }
            world.func_72908_a((double)x, (double)y, (double)z, soundName, volume, pitch);
        }
    }

    public static void playFX(World world, EntityPlayer player, int id, int x, int y, int z, int data) {
        if (RailcraftConfig.playSounds()) {
            world.func_72889_a(player, id, x, y, z, data);
        }
    }
}

