/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketTileRequest
extends RailcraftPacket {
    private TileEntity tile;
    private Player player;

    public PacketTileRequest(Player player) {
        this.player = player;
    }

    public PacketTileRequest(TileEntity tile) {
        this.tile = tile;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.tile.field_70331_k.field_73011_w.field_76574_g);
        data.writeInt(this.tile.field_70329_l);
        data.writeInt(this.tile.field_70330_m);
        data.writeInt(this.tile.field_70327_n);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        WorldServer world = DimensionManager.getWorld((int)data.readInt());
        if (world == null) {
            return;
        }
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        this.tile = world.func_72796_p(x, y, z);
        if (this.tile != null && this.player != null) {
            Packet pkt = this.tile.func_70319_e();
            PacketDispatcher.sendPacketToPlayer((Packet)pkt, (Player)this.player);
        }
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.TILE_REQUEST.ordinal();
    }
}

