/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.logging.Level;
import java.util.logging.Logger;
import mods.railcraft.common.core.RailcraftLanguage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class Game {
    private static final Logger log = Logger.getLogger("Railcraft");
    public static final boolean IS_OBFUSCATED = !World.class.getSimpleName().equals("World");
    public static final boolean IS_DEBUG = !"8.3.2.0".endsWith("0");

    public static boolean isHost(World world) {
        return !world.field_72995_K;
    }

    public static boolean isNotHost(World world) {
        return world.field_72995_K;
    }

    public static boolean isPlayerOp(String username) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new RuntimeException("You derped up! Don't call this on the client!");
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72376_i().contains(username);
    }

    @SideOnly(value=Side.CLIENT)
    public static World getWorld() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null) {
            return mc.field_71441_e;
        }
        return null;
    }

    public static boolean isObfuscated() {
        return IS_OBFUSCATED;
    }

    public static void log(Level level, String msg, Object ... args) {
        String m = msg;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            m = m.replace("{" + i + "}", args[i].toString());
        }
        log.log(level, m);
    }

    public static void logError(Level level, String msg, Object ... args) {
        Game.logError(level, 5, msg, args);
    }

    public static void logError(Level level, int lines, String msg, Object ... args) {
        Game.log(level, msg, args);
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stackTrace.length && i < 2 + lines; ++i) {
            Game.log(level, stackTrace[i].toString(), new Object[0]);
        }
    }

    public static void logDebug(Level level, String msg, Object ... args) {
        if (IS_DEBUG) {
            return;
        }
        String m = msg;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            m = m.replace("{" + i + "}", args[i].toString());
        }
        log.log(level, m);
    }

    public static void logErrorAPI(String mod, Throwable error, Class classFile) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" API error, please update your mods. Error: ").append(error);
        StackTraceElement[] stackTrace = error.getStackTrace();
        if (stackTrace.length > 0) {
            msg.append(", ").append(stackTrace[0]);
        }
        log.log(Level.SEVERE, msg.toString());
        if (classFile != null) {
            msg = new StringBuilder(mod);
            msg.append(" API error: ").append(classFile.getSimpleName()).append(" is loaded from ").append(classFile.getProtectionDomain().getCodeSource().getLocation());
            log.log(Level.SEVERE, msg.toString());
        }
    }

    public static void logError(String msg, Throwable error) {
        Game.logError(Level.SEVERE, msg, error);
    }

    public static void logError(Level level, String msg, Throwable error) {
        log.log(level, msg, error);
    }

    public static void logErrorFingerprint(String mod) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" failed validation, terminating. Please re-download ").append(mod).append(".");
        log.log(Level.SEVERE, msg.toString());
    }

    public static void sendLocalizedChat(EntityPlayer player, String msg, Object ... args) {
        player.func_71035_c(String.format(RailcraftLanguage.translate(msg), args));
    }

    static {
        FMLLog.makeLog((String)"Railcraft");
    }
}

