/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import com.google.common.collect.ForwardingQueue;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.util.Vec3;

public class CircularVec3Queue
extends ForwardingQueue {
    private final Vec3[] pool;
    private final ArrayDeque queue;
    private final int maxSize;
    private int poolIndex;

    public CircularVec3Queue(int maxSize) {
        this.maxSize = maxSize;
        this.pool = new Vec3[maxSize * 2];
        this.queue = new ArrayDeque(maxSize);
    }

    protected Queue delegate() {
        return this.queue;
    }

    public boolean add(double x, double y, double z) {
        if (this.maxSize == 0) {
            return true;
        }
        if (this.size() == this.maxSize) {
            this.queue.remove();
        }
        this.queue.add(this.getNextVec3(x, y, z));
        return true;
    }

    private Vec3 getNextVec3(double x, double y, double z) {
        if (this.poolIndex >= this.pool.length) {
            this.poolIndex = 0;
        }
        if (this.pool[this.poolIndex] == null) {
            Vec3 vec3 = Vec3.field_82592_a.func_72345_a(x, y, z);
            this.pool[this.poolIndex++] = vec3;
            return vec3;
        }
        this.pool[this.poolIndex].field_72450_a = x;
        this.pool[this.poolIndex].field_72448_b = y;
        this.pool[this.poolIndex].field_72449_c = z;
        return this.pool[this.poolIndex++];
    }

    public Iterator descendingIterator() {
        return this.queue.descendingIterator();
    }

    public Iterable descendingIterable() {
        return new Iterable(){

            public Iterator iterator() {
                return CircularVec3Queue.this.queue.descendingIterator();
            }
        };
    }
}

