/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.thaumcraft;

import cpw.mods.fml.common.Loader;
import java.util.HashMap;
import java.util.Map;
import mods.railcraft.common.blocks.aesthetics.brick.BlockBrick;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.glass.BlockStrengthGlass;
import mods.railcraft.common.blocks.anvil.BlockRCAnvil;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemDust;
import mods.railcraft.common.items.ItemGear;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.items.firestone.ItemFirestoneCracked;
import mods.railcraft.common.items.firestone.ItemFirestoneCut;
import mods.railcraft.common.items.firestone.ItemFirestoneRaw;
import mods.railcraft.common.items.firestone.ItemFirestoneRefined;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ItemApi;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchPage;

public class ThaumcraftPlugin {
    public static final String RESEARCH_CATAEGORY = "RAILCRAFT";
    private static Map itemCache = new HashMap();
    private static Map itemCacheFlag = new HashMap();
    private static Boolean modLoaded = null;

    public static ItemStack getItem(String tag, int meta) {
        if (!ThaumcraftPlugin.isModInstalled()) {
            return null;
        }
        Item item = (Item)itemCache.get(tag);
        if (item != null) {
            return new ItemStack(item, 1, meta);
        }
        Boolean wasCached = (Boolean)itemCacheFlag.get(tag);
        if (wasCached == Boolean.TRUE) {
            return null;
        }
        try {
            itemCacheFlag.put(tag, Boolean.TRUE);
            ItemStack stack = ItemApi.getItem(tag, meta);
            if (stack != null && stack.func_77973_b() != null) {
                itemCache.put(tag, stack.func_77973_b());
            }
            return stack;
        }
        catch (Throwable error) {
            Game.logErrorAPI("Thaumcraft", error, ItemApi.class);
            return null;
        }
    }

    public static void setupReseach() {
        RailcraftLanguage.instance().pushTagToMinecraft("thaumcraft.research.category.RAILCRAFT", "tc.research_category.RAILCRAFT");
        ResearchCategories.registerCategory(RESEARCH_CATAEGORY, new ResourceLocation("railcraft", "textures/items/tool.crowbar.magic.png"), new ResourceLocation("thaumcraft", "textures/gui/gui_researchback.png"));
    }

    public static ResearchPage createResearchPage(String key, int pageNum) {
        return new ResearchPage(RailcraftLanguage.translate(String.format("thaumcraft.research.%s.page.%d", key, pageNum)).replace("\n", "<BR>").replace("---", "<LINE>").replace("{img}", "<IMG>").replace("{/img}", "</IMG>"));
    }

    public static void registerAspects() {
        try {
            AspectList anchorAspects = new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.ORDER, 4).add(Aspect.MAGIC, 2).add(Aspect.GREED, 2);
            AspectList steamAspects = new AspectList().add(Aspect.WATER, 3).add(Aspect.MECHANISM, 2).add(Aspect.FIRE, 3);
            AspectList tankAspects = new AspectList().add(Aspect.VOID, 4).add(Aspect.WATER, 4);
            ThaumcraftPlugin.addBrickAspects(BlockBrick.abyssal, Aspect.DARKNESS);
            ThaumcraftPlugin.addBrickAspects(BlockBrick.bleachedbone, Aspect.DEATH);
            ThaumcraftPlugin.addBrickAspects(BlockBrick.bloodstained, Aspect.FLESH);
            ThaumcraftPlugin.addBrickAspects(BlockBrick.frostbound, Aspect.ICE);
            ThaumcraftPlugin.addBrickAspects(BlockBrick.infernal, 2, Aspect.FIRE, Aspect.SOUL);
            ThaumcraftPlugin.addBrickAspects(BlockBrick.nether, Aspect.FIRE);
            ThaumcraftPlugin.addBrickAspects(BlockBrick.quarried, Aspect.LIGHT);
            ThaumcraftPlugin.addBrickAspects(BlockBrick.sandy, Aspect.EARTH);
            ThaumcraftPlugin.addItemAspect(EnumCube.ABYSSAL_STONE.getItem(), new AspectList().add(Aspect.STONE, 4).add(Aspect.DARKNESS, 2));
            ThaumcraftPlugin.addItemAspect(EnumCube.QUARRIED_STONE.getItem(), new AspectList().add(Aspect.STONE, 4).add(Aspect.LIGHT, 2));
            ThaumcraftPlugin.addItemAspect(EnumCube.CRUSHED_OBSIDIAN.getItem(), new AspectList(Block.field_72089_ap.field_71990_ca, -1).remove(Aspect.STONE, 1).add(Aspect.ENTROPY, 1).add(Aspect.ELDRITCH, 1));
            ThaumcraftPlugin.addItemAspect(EnumCube.CONCRETE_BLOCK.getItem(), new AspectList().remove(Aspect.STONE, 3).add(Aspect.METAL, 1));
            ThaumcraftPlugin.addItemAspect(EnumCube.CREOSOTE_BLOCK.getItem(), new AspectList().remove(Aspect.TREE, 3).add(Aspect.ORDER, 1));
            ThaumcraftPlugin.addItemAspect(EnumOre.DARK_DIAMOND.getItem(), new AspectList(Block.field_72073_aw.field_71990_ca, -1).add(Aspect.DARKNESS, 1));
            ThaumcraftPlugin.addItemAspect(EnumOre.DARK_EMERALD.getItem(), new AspectList(Block.field_72068_bR.field_71990_ca, -1).add(Aspect.DARKNESS, 1));
            ThaumcraftPlugin.addItemAspect(EnumOre.DARK_LAPIS.getItem(), new AspectList(Block.field_71947_N.field_71990_ca, -1).add(Aspect.DARKNESS, 1));
            ThaumcraftPlugin.addItemAspect(EnumOre.SULFUR.getItem(), new AspectList().add(Aspect.STONE, 1).add(Aspect.FIRE, 3));
            ThaumcraftPlugin.addItemAspect(EnumOre.SALTPETER.getItem(), new AspectList().add(Aspect.STONE, 1).add(Aspect.AIR, 3));
            ThaumcraftPlugin.addItemAspect(EnumOre.FIRESTONE.getItem(), new AspectList().add(Aspect.STONE, 1).add(Aspect.FIRE, 6).add(Aspect.ENTROPY, 1));
            ThaumcraftPlugin.addItemAspect(ItemDust.getDust(ItemDust.EnumDust.SULFUR), new AspectList().add(Aspect.ENTROPY, 1).add(Aspect.FIRE, 3));
            ThaumcraftPlugin.addItemAspect(ItemDust.getDust(ItemDust.EnumDust.SALTPETER), new AspectList().add(Aspect.ENTROPY, 1).add(Aspect.AIR, 3));
            ThaumcraftPlugin.addItemAspect(ItemDust.getDust(ItemDust.EnumDust.CHARCOAL), new AspectList().add(Aspect.ENTROPY, 1).add(Aspect.FIRE, 2));
            ThaumcraftPlugin.addItemAspect(ItemDust.getDust(ItemDust.EnumDust.OBSIDIAN), new AspectList(Block.field_72089_ap.field_71990_ca, -1).remove(Aspect.STONE, 2).add(Aspect.ENTROPY, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftPartItems.getRebar(), new AspectList().add(Aspect.METAL, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftPartItems.getRailStandard(), new AspectList().add(Aspect.METAL, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftPartItems.getRailReinforced(), new AspectList().add(Aspect.METAL, 1).add(Aspect.ORDER, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftPartItems.getRailWood(), new AspectList().add(Aspect.TREE, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftPartItems.getRailAdvanced(), new AspectList().add(Aspect.METAL, 1).add(Aspect.MECHANISM, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftPartItems.getTieWood(), new AspectList().add(Aspect.TREE, 3).add(Aspect.ORDER, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftPartItems.getTieStone(), new AspectList().add(Aspect.STONE, 3).add(Aspect.METAL, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftToolItems.getCoalCoke(), new AspectList().add(Aspect.FIRE, 4).add(Aspect.ENERGY, 4));
            ThaumcraftPlugin.addItemAspect(ItemPlate.getPlate(ItemPlate.EnumPlate.IRON), new AspectList().add(Aspect.METAL, 4));
            ThaumcraftPlugin.addItemAspect(ItemPlate.getPlate(ItemPlate.EnumPlate.STEEL), new AspectList().add(Aspect.METAL, 3).add(Aspect.ORDER, 1));
            ThaumcraftPlugin.addItemAspect(ItemGear.getGoldPlateGear(), new AspectList().add(Aspect.METAL, 4).add(Aspect.ORDER, 1).add(Aspect.MECHANISM, 2).add(Aspect.GREED, 2));
            ThaumcraftPlugin.addItemAspect(ItemGear.getSteelGear(), new AspectList().add(Aspect.METAL, 8).add(Aspect.ORDER, 2).add(Aspect.MECHANISM, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.ROLLING_MACHINE.getItem(), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MECHANISM, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.ROCK_CRUSHER.getItem(), new AspectList().add(Aspect.CRAFT, 2).add(Aspect.MECHANISM, 4).add(Aspect.EARTH, 4).add(Aspect.STONE, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.FEED_STATION.getItem(), new AspectList().add(Aspect.CROP, 4).add(Aspect.HUNGER, 4).add(Aspect.MECHANISM, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.SMOKER.getItem(), new AspectList().add(Aspect.FIRE, 4).add(Aspect.AIR, 4).add(Aspect.MECHANISM, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.SMOKER.getItem(), new AspectList().add(Aspect.FIRE, 4).add(Aspect.AIR, 4).add(Aspect.MECHANISM, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.STEAM_TRAP_MANUAL.getItem(), steamAspects.copy().add(Aspect.TRAP, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.STEAM_TRAP_AUTO.getItem(), steamAspects.copy().add(Aspect.TRAP, 4).add(Aspect.MIND, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.STEAM_OVEN.getItem(), steamAspects.copy().add(Aspect.FIRE, 3));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.TURBINE.getItem(), steamAspects.copy().add(Aspect.ENERGY, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.ADMIN_ANCHOR.getItem(), anchorAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.PERSONAL_ANCHOR.getItem(), anchorAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.WORLD_ANCHOR.getItem(), anchorAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.SENTINEL.getItem(), anchorAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.BOILER_FIREBOX_SOLID.getItem(), steamAspects.copy().add(Aspect.ENERGY, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.BOILER_FIREBOX_LIQUID.getItem(), steamAspects.copy().add(Aspect.ENERGY, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.getItem(), steamAspects.copy().add(Aspect.ENERGY, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.getItem(), steamAspects.copy().add(Aspect.ENERGY, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.ENGINE_STEAM_HOBBY.getItem(), steamAspects.copy().add(Aspect.ENERGY, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.ENGINE_STEAM_LOW.getItem(), steamAspects.copy().add(Aspect.ENERGY, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.ENGINE_STEAM_HIGH.getItem(), steamAspects.copy().add(Aspect.ENERGY, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.TANK_WATER.getItem(), tankAspects.copy().add(Aspect.TREE, 2).add(Aspect.SLIME, 2));
            AspectList ironTankAspects = tankAspects.copy().add(Aspect.METAL, 2);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_IRON_GAUGE.getItem(), ironTankAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_IRON_VALVE.getItem(), ironTankAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_IRON_WALL.getItem(), ironTankAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_STEEL_GAUGE.getItem(), ironTankAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_STEEL_VALVE.getItem(), ironTankAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_STEEL_WALL.getItem(), ironTankAspects);
            AspectList detectorAspects = new AspectList().add(Aspect.SENSES, 4).add(Aspect.MECHANISM, 4);
            for (EnumDetector detector : EnumDetector.VALUES) {
                ThaumcraftPlugin.addItemAspect(detector.getItem(), detectorAspects);
            }
            AspectList glassAspects = new AspectList().add(Aspect.CRYSTAL, 4).add(Aspect.METAL, 1);
            for (EnumColor color : EnumColor.VALUES) {
                ThaumcraftPlugin.addItemAspect(BlockStrengthGlass.getItem(color.ordinal()), glassAspects);
            }
            ThaumcraftPlugin.addItemAspect(BlockRCAnvil.getBlock(), new AspectList().add(Aspect.CRAFT, 4).add(Aspect.MAGIC, 2).add(Aspect.METAL, 4).add(Aspect.ORDER, 2));
            ThaumcraftPlugin.addCartAspect(EnumCart.LOCO_STEAM, steamAspects.copy().add(Aspect.MOTION, 2).add(Aspect.TRAVEL, 4));
            ThaumcraftPlugin.addCartAspect(EnumCart.PUMPKIN, new AspectList(Block.field_72061_ba.field_71990_ca, 0).add(Aspect.MOTION, 2).add(Aspect.ENTROPY, 6));
            ThaumcraftPlugin.addCartAspect(EnumCart.ANCHOR, anchorAspects.copy().add(Aspect.MOTION, 2).add(Aspect.TRAVEL, 2));
            ThaumcraftPlugin.addCartAspect(EnumCart.ANCHOR_ADMIN, anchorAspects.copy().add(Aspect.MOTION, 2).add(Aspect.TRAVEL, 2));
            ThaumcraftPlugin.addCartAspect(EnumCart.ANCHOR_PERSONAL, anchorAspects.copy().add(Aspect.MOTION, 2).add(Aspect.TRAVEL, 2));
            ThaumcraftPlugin.addItemAspect(ItemGoggles.getItem(), new AspectList().add(Aspect.AURA, 4).add(Aspect.SENSES, 4));
            ThaumcraftPlugin.addItemAspect(ItemFirestoneRaw.getItem(), new AspectList().add(Aspect.FIRE, 6).add(Aspect.CRYSTAL, 2).add(Aspect.ENTROPY, 4));
            ThaumcraftPlugin.addItemAspect(ItemFirestoneCut.getItem(), new AspectList().add(Aspect.FIRE, 6).add(Aspect.CRYSTAL, 2).add(Aspect.ENTROPY, 2).add(Aspect.ORDER, 2));
            ThaumcraftPlugin.addItemAspect(ItemFirestoneRefined.getItemCharged(), new AspectList().add(Aspect.FIRE, 6).add(Aspect.CRYSTAL, 2).add(Aspect.ORDER, 4));
            ThaumcraftPlugin.addItemAspect(ItemFirestoneCracked.getItemCharged(), new AspectList().add(Aspect.FIRE, 6).add(Aspect.CRYSTAL, 2).add(Aspect.ENTROPY, 4));
        }
        catch (Throwable error) {
            Game.logErrorAPI("Thaumcraft", error, ThaumcraftApi.class);
        }
    }

    private static void addItemAspect(ItemStack stack, AspectList aspects) {
        ThaumcraftApi.registerObjectTag(stack.field_77993_c, stack.func_77981_g() ? stack.func_77960_j() : -1, aspects);
    }

    private static void addItemAspect(Block block, AspectList aspects) {
        ThaumcraftApi.registerObjectTag(block.field_71990_ca, -1, aspects);
    }

    private static void addItemAspectComplex(ItemStack stack, AspectList aspects) {
        ThaumcraftApi.registerComplexObjectTag(stack.field_77993_c, stack.func_77981_g() ? stack.func_77960_j() : -1, aspects);
    }

    private static void addCartAspect(EnumCart cart, AspectList aspects) {
        ThaumcraftPlugin.addItemAspect(cart.getCartItem(), aspects);
        ThaumcraftApi.registerEntityTag(cart.getTag(), aspects, new NBTBase[0]);
    }

    private static void addBrickAspects(Block block, Aspect baseAspect) {
        ThaumcraftPlugin.addBrickAspects(block, 4, baseAspect);
    }

    private static void addBrickAspects(Block block, int baseAmount, Aspect ... baseAspects) {
        AspectList aspects = new AspectList().add(Aspect.STONE, 4);
        for (Aspect a : baseAspects) {
            aspects.add(a, baseAmount);
        }
        ThaumcraftApi.registerObjectTag(block.field_71990_ca, -1, aspects);
        ThaumcraftApi.registerObjectTag(block.field_71990_ca, BlockBrick.BrickVariant.COBBLE.ordinal(), aspects.copy().remove(Aspect.STONE, 2).add(Aspect.ENTROPY, 2));
        ThaumcraftApi.registerObjectTag(block.field_71990_ca, BlockBrick.BrickVariant.BLOCK.ordinal(), aspects.copy().remove(Aspect.STONE, 2).add(Aspect.ORDER, 2));
        ThaumcraftApi.registerObjectTag(block.field_71990_ca, BlockBrick.BrickVariant.ETCHED.ordinal(), aspects.copy().remove(Aspect.STONE, 2).add(Aspect.GREED, 2));
    }

    public static EnumToolMaterial getThaumiumToolMaterial() {
        try {
            return ThaumcraftApi.toolMatThaumium;
        }
        catch (Throwable error) {
            Game.logErrorAPI("Thaumcraft", error, ThaumcraftApi.class);
            return EnumToolMaterial.IRON;
        }
    }

    public static boolean isModInstalled() {
        if (modLoaded == null) {
            modLoaded = Loader.isModLoaded((String)"Thaumcraft");
        }
        return modLoaded;
    }
}

