/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items.firestone;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.Random;
import mods.railcraft.common.blocks.ore.BlockOre;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.items.firestone.ItemFirestoneCracked;
import mods.railcraft.common.items.firestone.ItemFirestoneCut;
import mods.railcraft.common.items.firestone.ItemFirestoneRaw;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class FirestoneTickHandler
implements IScheduledTickHandler {
    private static EnumSet tickTypes = EnumSet.of(TickType.PLAYER);

    public int nextTickSpacing() {
        return 4;
    }

    private boolean shouldBurn(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (stack.func_77973_b() == ItemFirestoneRaw.item) {
            return true;
        }
        if (stack.func_77973_b() == ItemFirestoneCut.item) {
            return true;
        }
        if (stack.func_77973_b() == ItemFirestoneCracked.item) {
            return true;
        }
        return BlockOre.getBlock() != null && stack.field_77993_c == BlockOre.getBlock().field_71990_ca && stack.func_77960_j() == EnumOre.FIRESTONE.ordinal();
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        EntityPlayer player = (EntityPlayer)tickData[0];
        if (player.field_71070_bA != player.field_71069_bz) {
            return;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!this.shouldBurn(stack)) continue;
            boolean spawnedFire = false;
            for (int i = 0; i < stack.field_77994_a; ++i) {
                spawnedFire |= this.spawnFire(player);
            }
            if (!spawnedFire || !stack.func_77984_f() || stack.func_77960_j() >= stack.func_77958_k() - 1) continue;
            InvTools.damageItem(stack, 1);
        }
    }

    private boolean spawnFire(EntityPlayer player) {
        Random rnd = player.func_70681_au();
        int x = (int)Math.round(player.field_70165_t) - 5 + rnd.nextInt(12);
        int y = (int)Math.round(player.field_70163_u) - 5 + rnd.nextInt(12);
        int z = (int)Math.round(player.field_70161_v) - 5 + rnd.nextInt(12);
        if (y < 1) {
            y = 1;
        }
        if (y > player.field_70170_p.func_72940_L()) {
            y = player.field_70170_p.func_72940_L() - 2;
        }
        if (this.canBurn(player.field_70170_p, x, y, z)) {
            return player.field_70170_p.func_94575_c(x, y, z, Block.field_72067_ar.field_71990_ca);
        }
        return false;
    }

    private boolean canBurn(World world, int x, int y, int z) {
        if (world.func_72798_a(x, y, z) != 0) {
            return false;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            Block block;
            int sz;
            int sy;
            int sx = MiscTools.getXOnSide(x, side);
            if (world.func_72799_c(sx, sy = MiscTools.getYOnSide(y, side), sz = MiscTools.getZOnSide(z, side)) || (block = WorldPlugin.getBlock((IBlockAccess)world, sx, sy, sz)) == Block.field_72067_ar) continue;
            return true;
        }
        return false;
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return tickTypes;
    }

    public String getLabel() {
        return "Firestone Ticker";
    }
}

