/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import java.util.Locale;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.oredict.OreDictionary;

public class ItemDust
extends ItemRailcraft {
    private static ItemDust item;

    public static ItemStack getDust(EnumDust dust) {
        return ItemDust.getDust(dust, 1);
    }

    public static ItemStack getDust(EnumDust dust, int qty) {
        if (item != null) {
            return new ItemStack((Item)item, qty, dust.ordinal());
        }
        String tag = "railcraft.dust";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return null;
        }
        item = new ItemDust(id);
        GameRegistry.registerItem((Item)item, (String)tag);
        for (EnumDust d : EnumDust.values()) {
            ItemStack stack = new ItemStack((Item)item, 1, d.ordinal());
            RailcraftLanguage.instance().registerItemName(stack, item.func_77667_c(stack));
            ItemRegistry.registerItemStack(item.func_77667_c(stack), stack);
            ForestryPlugin.addBackpackItem("miner", stack);
        }
        OreDictionary.registerOre((String)"dustObsidian", (ItemStack)new ItemStack((Item)item, 1, EnumDust.OBSIDIAN.ordinal()));
        OreDictionary.registerOre((String)"dustSulfur", (ItemStack)new ItemStack((Item)item, 1, EnumDust.SULFUR.ordinal()));
        OreDictionary.registerOre((String)"dustSaltpeter", (ItemStack)new ItemStack((Item)item, 1, EnumDust.SALTPETER.ordinal()));
        OreDictionary.registerOre((String)"dustCharcoal", (ItemStack)new ItemStack((Item)item, 1, EnumDust.CHARCOAL.ordinal()));
        if (IC2Plugin.isModInstalled() && RailcraftConfig.getRecipeConfig("ic2.macerator.charcoal")) {
            IC2Plugin.addMaceratorRecipe(new ItemStack(Item.field_77705_m, 1, 1), new ItemStack((Item)item, 1, EnumDust.CHARCOAL.ordinal()));
        }
        return new ItemStack((Item)item, qty, dust.ordinal());
    }

    public ItemDust(int id) {
        super(id);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("railcraft.dust");
    }

    @Override
    public void func_94581_a(IconRegister iconRegister) {
        for (EnumDust dust : EnumDust.VALUES) {
            dust.icon = iconRegister.func_94245_a("railcraft:dust." + dust.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public void func_77633_a(int id, CreativeTabs tab, List list) {
        for (EnumDust dust : EnumDust.VALUES) {
            list.add(new ItemStack((Item)this, 1, dust.ordinal()));
        }
    }

    public Icon func_77617_a(int damage) {
        if (damage >= EnumDust.VALUES.length) {
            return EnumDust.CHARCOAL.icon;
        }
        return EnumDust.VALUES[damage].icon;
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage < 0 || damage >= EnumDust.VALUES.length) {
            return "";
        }
        switch (EnumDust.VALUES[damage]) {
            case OBSIDIAN: {
                return "railcraft.dust.obsidian";
            }
            case SULFUR: {
                return "railcraft.dust.sulfur";
            }
            case SALTPETER: {
                return "railcraft.dust.saltpeter";
            }
            case CHARCOAL: {
                return "railcraft.dust.charcoal";
            }
        }
        return "";
    }

    public static enum EnumDust {
        OBSIDIAN,
        SULFUR,
        SALTPETER,
        CHARCOAL;

        public static final EnumDust[] VALUES;
        private Icon icon;

        static {
            VALUES = EnumDust.values();
        }
    }
}

