/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFireboxSolid;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotFuel;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotWater;
import mods.railcraft.common.gui.widgets.FluidGaugeWidget;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerBoilerSolid
extends RailcraftContainer {
    private TileBoilerFireboxSolid tile;
    private Slot fuel;
    private Slot input;
    private Slot output;
    private float lastBurnTime;
    private float lastItemBurnTime;
    private float lastHeat;

    public ContainerBoilerSolid(InventoryPlayer inventoryplayer, TileBoilerFireboxSolid tile) {
        super(tile);
        this.tile = tile;
        this.addWidget(new FluidGaugeWidget(tile.getTankManager().get(0), 116, 23, 176, 0, 16, 47));
        this.addWidget(new FluidGaugeWidget(tile.getTankManager().get(1), 17, 23, 176, 0, 16, 47));
        this.addWidget(new IndicatorWidget(tile.boiler.heatIndicator, 40, 25, 176, 61, 6, 43));
        this.input = new SlotWater(tile, 0, 143, 21);
        this.addSlot(this.input);
        this.output = new SlotOutput(tile, 1, 143, 56);
        this.addSlot(this.output);
        this.fuel = new SlotFuel(tile, 2, 62, 39);
        this.addSlot(this.fuel);
        this.addSlot(new SlotFuel(tile, 3, 89, 20));
        this.addSlot(new SlotFuel(tile, 4, 89, 38));
        this.addSlot(new SlotFuel(tile, 5, 89, 56));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        TankManager tMan = this.tile.getTankManager();
        if (tMan != null) {
            tMan.initGuiData(this, icrafting, 0);
            tMan.initGuiData(this, icrafting, 1);
        }
        icrafting.func_71112_a((Container)this, 10, Math.round(this.tile.boiler.burnTime));
        icrafting.func_71112_a((Container)this, 11, Math.round(this.tile.boiler.currentItemBurnTime));
        icrafting.func_71112_a((Container)this, 12, Math.round(this.tile.boiler.getHeat()));
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        TankManager tMan = this.tile.getTankManager();
        if (tMan != null) {
            tMan.updateGuiData(this, this.field_75149_d, 0);
            tMan.updateGuiData(this, this.field_75149_d, 1);
        }
        for (int var1 = 0; var1 < this.field_75149_d.size(); ++var1) {
            ICrafting var2 = (ICrafting)this.field_75149_d.get(var1);
            if (this.lastBurnTime != this.tile.boiler.burnTime) {
                var2.func_71112_a((Container)this, 10, Math.round(this.tile.boiler.burnTime));
            }
            if (this.lastItemBurnTime != this.tile.boiler.currentItemBurnTime) {
                var2.func_71112_a((Container)this, 11, Math.round(this.tile.boiler.currentItemBurnTime));
            }
            if (this.lastHeat == this.tile.boiler.getHeat()) continue;
            var2.func_71112_a((Container)this, 12, Math.round(this.tile.boiler.getHeat()));
        }
        this.lastBurnTime = this.tile.boiler.burnTime;
        this.lastItemBurnTime = this.tile.boiler.currentItemBurnTime;
        this.lastHeat = this.tile.boiler.getHeat();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        TankManager tMan = this.tile.getTankManager();
        if (tMan != null) {
            tMan.processGuiUpdate(id, value);
        }
        switch (id) {
            case 10: {
                this.tile.boiler.burnTime = value;
                break;
            }
            case 11: {
                this.tile.boiler.currentItemBurnTime = value;
                break;
            }
            case 12: {
                this.tile.boiler.setHeat(value);
            }
        }
    }
}

