/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import java.util.Locale;
import mods.railcraft.common.fluids.FluidHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public enum Fluids {
    WATER,
    LAVA,
    FUEL,
    BIOFUEL,
    CREOSOTE,
    STEAM,
    BIOETHANOL;

    private String tag = this.name().toLowerCase(Locale.ENGLISH);

    public String getTag() {
        return this.tag;
    }

    public Fluid get() {
        return FluidRegistry.getFluid((String)this.tag);
    }

    public FluidStack get(int qty) {
        return FluidRegistry.getFluidStack((String)this.tag, (int)qty);
    }

    public boolean is(Fluid fluid) {
        return this.get() == fluid;
    }

    public boolean is(FluidStack fluidStack) {
        return fluidStack != null && this.get() == fluidStack.getFluid();
    }

    public boolean isContained(ItemStack containerStack) {
        return containerStack != null && FluidHelper.containsFluid(containerStack, this.get());
    }

    public static boolean areEqual(Fluid fluid, FluidStack fluidStack) {
        if (fluidStack != null && fluid == fluidStack.getFluid()) {
            return true;
        }
        return fluid == null && fluidStack == null;
    }
}

