/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import com.google.common.collect.MapMaker;
import java.util.Iterator;
import java.util.Map;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.util.misc.CircularVec3Queue;
import mods.railcraft.common.util.misc.Vec2D;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;

public class LinkageHandler {
    public static final String LINK_A_TIMER = "linkA_timer";
    public static final String LINK_B_TIMER = "linkB_timer";
    public static final double LINK_DRAG = 0.95;
    public static final float MAX_DISTANCE = 8.0f;
    private static final float STIFFNESS = 0.7f;
    private static final float HS_STIFFNESS = 0.7f;
    private static final float DAMPING = 0.4f;
    private static final float HS_DAMPING = 0.3f;
    private static final float FORCE_LIMITER = 6.0f;
    private static final int TICK_HISTORY = 200;
    private static LinkageHandler instance;
    private static Map history;

    private LinkageHandler() {
    }

    public static LinkageHandler getInstance() {
        if (instance == null) {
            instance = new LinkageHandler();
        }
        return instance;
    }

    private float getOptimalDistance(EntityMinecart cart1, EntityMinecart cart2) {
        float dist = 0.0f;
        dist = cart1 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart1).getOptimalDistance(cart2)) : (dist += 0.78f);
        dist = cart2 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart2).getOptimalDistance(cart1)) : (dist += 0.78f);
        return dist;
    }

    private boolean canCartBeAdjustedBy(EntityMinecart cart1, EntityMinecart cart2) {
        if (cart1 == cart2) {
            return false;
        }
        if (cart1 instanceof ILinkableCart && !((ILinkableCart)cart1).canBeAdjusted(cart2)) {
            return false;
        }
        return !RailTools.isCartLockedDown(cart1);
    }

    protected void adjustVelocity(EntityMinecart cart1, EntityMinecart cart2, char link) {
        String timer = LINK_A_TIMER;
        if (link == 'B') {
            timer = LINK_B_TIMER;
        }
        if (cart1.field_70170_p.field_73011_w.field_76574_g != cart2.field_70170_p.field_73011_w.field_76574_g) {
            short count = cart1.getEntityData().func_74765_d(timer);
            if ((count = (short)(count + 1)) > 200) {
                LinkageManager.instance().breakLink(cart1, cart2);
                LinkageManager.printDebug("Reason For Broken Link: Carts in different dimensions.", new Object[0]);
            }
            cart1.getEntityData().func_74777_a(timer, count);
            return;
        }
        cart1.getEntityData().func_74777_a(timer, (short)0);
        double dist = cart1.func_70032_d((Entity)cart2);
        if (dist > 8.0) {
            LinkageManager.instance().breakLink(cart1, cart2);
            LinkageManager.printDebug("Reason For Broken Link: Max distance exceeded.", new Object[0]);
            return;
        }
        boolean adj1 = this.canCartBeAdjustedBy(cart1, cart2);
        boolean adj2 = this.canCartBeAdjustedBy(cart2, cart1);
        Vec2D cart1Pos = new Vec2D(cart1.field_70165_t, cart1.field_70161_v);
        Vec2D cart2Pos = new Vec2D(cart2.field_70165_t, cart2.field_70161_v);
        Vec2D unit = Vec2D.subtract(cart2Pos, cart1Pos);
        unit.normalize();
        float optDist = this.getOptimalDistance(cart1, cart2);
        double stretch = dist - (double)optDist;
        boolean highSpeed = cart1.getEntityData().func_74767_n("HighSpeed");
        double stiffness = highSpeed ? (double)0.7f : (double)0.7f;
        double springX = stiffness * stretch * unit.getX();
        double springZ = stiffness * stretch * unit.getY();
        springX = this.limitForce(springX);
        springZ = this.limitForce(springZ);
        if (adj1) {
            cart1.field_70159_w += springX;
            cart1.field_70179_y += springZ;
        }
        if (adj2) {
            cart2.field_70159_w -= springX;
            cart2.field_70179_y -= springZ;
        }
        Vec2D cart1Vel = new Vec2D(cart1.field_70159_w, cart1.field_70179_y);
        Vec2D cart2Vel = new Vec2D(cart2.field_70159_w, cart2.field_70179_y);
        double dot = Vec2D.subtract(cart2Vel, cart1Vel).dotProduct(unit);
        double damping = highSpeed ? (double)0.3f : (double)0.4f;
        double dampX = damping * dot * unit.getX();
        double dampZ = damping * dot * unit.getY();
        dampX = this.limitForce(dampX);
        dampZ = this.limitForce(dampZ);
        if (adj1) {
            cart1.field_70159_w += dampX;
            cart1.field_70179_y += dampZ;
        }
        if (adj2) {
            cart2.field_70159_w -= dampX;
            cart2.field_70179_y -= dampZ;
        }
    }

    private float getTrainMaxSpeed(EntityMinecart cart) {
        float speed;
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkA = lm.getLinkedCartA(cart);
        EntityMinecart linkB = lm.getLinkedCartB(cart);
        float min1 = speed = cart.getMaxCartSpeedOnRail();
        min1 = Math.min(min1, this.getTrainMaxSpeedRecursive(linkA, cart));
        float min2 = speed;
        min2 = Math.min(min2, this.getTrainMaxSpeedRecursive(linkB, cart));
        return Math.min(min1, min2);
    }

    private float getTrainMaxSpeedRecursive(EntityMinecart cart, EntityMinecart prev) {
        float speed;
        if (cart == null) {
            return Float.MAX_VALUE;
        }
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkA = lm.getLinkedCartA(cart);
        EntityMinecart linkB = lm.getLinkedCartB(cart);
        float min1 = speed = cart.getMaxCartSpeedOnRail();
        if (linkA != prev) {
            min1 = Math.min(min1, this.getTrainMaxSpeedRecursive(linkA, cart));
        }
        float min2 = speed;
        if (linkB != prev) {
            min2 = Math.min(min2, this.getTrainMaxSpeedRecursive(linkB, cart));
        }
        return Math.min(min1, min2);
    }

    private void setTrainMaxSpeed(EntityMinecart cart, float trainSpeed) {
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkA = lm.getLinkedCartA(cart);
        EntityMinecart linkB = lm.getLinkedCartB(cart);
        this.setTrainMaxSpeedRecursive(linkA, cart, trainSpeed);
        this.setTrainMaxSpeedRecursive(linkB, cart, trainSpeed);
        cart.setCurrentCartSpeedCapOnRail(trainSpeed);
    }

    private void setTrainMaxSpeedRecursive(EntityMinecart cart, EntityMinecart prev, float trainSpeed) {
        if (cart == null) {
            return;
        }
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkA = lm.getLinkedCartA(cart);
        EntityMinecart linkB = lm.getLinkedCartB(cart);
        if (linkA != prev) {
            this.setTrainMaxSpeedRecursive(linkA, cart, trainSpeed);
        }
        if (linkB != prev) {
            this.setTrainMaxSpeedRecursive(linkB, cart, trainSpeed);
        }
        cart.setCurrentCartSpeedCapOnRail(trainSpeed);
    }

    private double limitForce(double force) {
        return Math.copySign(Math.min(Math.abs(force), 6.0), force);
    }

    private void adjustCart(EntityMinecart cart, LinkageManager lm) {
        EntityMinecart link_B;
        int launched = cart.getEntityData().func_74762_e("Launched");
        if (launched > 0) {
            return;
        }
        if (this.isOnElevator(cart)) {
            return;
        }
        boolean linked = false;
        EntityMinecart link_A = lm.getLinkedCartA(cart);
        if (link_A != null && (launched = link_A.getEntityData().func_74762_e("Launched")) <= 0 && !this.isOnElevator(link_A)) {
            linked = true;
            this.adjustVelocity(cart, link_A, 'A');
            this.adjustCartFromHistory(cart, link_A);
        }
        if ((link_B = lm.getLinkedCartB(cart)) != null && (launched = link_B.getEntityData().func_74762_e("Launched")) <= 0 && !this.isOnElevator(link_B)) {
            linked = true;
            this.adjustVelocity(cart, link_B, 'B');
            this.adjustCartFromHistory(cart, link_B);
        }
        if (linked && ModuleManager.isModuleLoaded(ModuleManager.Module.LOCOMOTIVES)) {
            cart.field_70159_w *= 0.95;
            cart.field_70179_y *= 0.95;
        }
        if (link_A == null && link_B != null || link_A != null && link_B == null) {
            float trainSpeed = this.getTrainMaxSpeed(cart);
            this.setTrainMaxSpeed(cart, trainSpeed);
        } else if (link_A == null && link_B == null) {
            this.setTrainMaxSpeed(cart, 1.2f);
        }
    }

    private boolean isCartLeading(EntityMinecart leader, EntityMinecart follower) {
        return true;
    }

    private void adjustCartFromHistory(EntityMinecart current, EntityMinecart linked) {
        if (this.isCartLeading(current, linked)) {
            return;
        }
        CircularVec3Queue leaderHistory = (CircularVec3Queue)((Object)history.get(linked));
        double optimalDist = this.getOptimalDistance(current, linked);
        optimalDist *= optimalDist;
        double currentDistance = linked.func_70068_e((Entity)current);
        Vec3 closestPoint = null;
        Vec3 linkedVec = current.field_70170_p.func_82732_R().func_72345_a(linked.field_70165_t, linked.field_70163_u, linked.field_70161_v);
        double distance = Math.abs(optimalDist - currentDistance);
        Iterator i$ = leaderHistory.iterator();
        while (i$.hasNext()) {
            Vec3 pos = (Vec3)i$.next();
            double historyDistance = linkedVec.func_72436_e(pos);
            double diff = Math.abs(optimalDist - historyDistance);
            if (!(diff < distance)) continue;
            closestPoint = pos;
            distance = diff;
        }
        if (closestPoint != null) {
            current.func_70107_b(closestPoint.field_72450_a, closestPoint.field_72448_b, closestPoint.field_72449_c);
        }
    }

    private void savePosition(EntityMinecart cart) {
        CircularVec3Queue myHistory = (CircularVec3Queue)((Object)history.get(cart));
        if (myHistory == null) {
            myHistory = new CircularVec3Queue(200);
            history.put(cart, myHistory);
        }
        myHistory.add(cart.field_70165_t, cart.field_70163_u, cart.field_70161_v);
    }

    @ForgeSubscribe
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        EntityMinecart cart = event.minecart;
        LinkageManager lm = LinkageManager.instance();
        if (cart.field_70128_L) {
            lm.removeLinkageId(cart);
            return;
        }
        lm.getLinkageId(cart);
        this.adjustCart(cart, lm);
        this.savePosition(cart);
    }

    @ForgeSubscribe
    public void onMinecartInteract(MinecartInteractEvent event) {
        EntityPlayer player = event.player;
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IToolCrowbar) {
            event.setCanceled(true);
        }
    }

    private boolean isOnElevator(EntityMinecart cart) {
        byte elevator = cart.getEntityData().func_74771_c("elevator");
        return elevator > 0;
    }

    static {
        history = new MapMaker().weakKeys().makeMap();
    }
}

