/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.carts.IItemTransfer;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.carts.bore.IBoreHead;
import mods.railcraft.api.carts.bore.IMineable;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.DamageSourceBore;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.BallastRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class EntityTunnelBore
extends CartContainerBase
implements IInventory,
ILinkableCart {
    public static final float SPEED = 0.03f;
    public static final float LENGTH = 6.0f;
    public static final int MAX_FILL_DEPTH = 10;
    public static final int FAIL_DELAY = 200;
    public static final int STANDARD_DELAY = 5;
    public static final int LAYER_DELAY = 40;
    public static final int BALLAST_DELAY = 10;
    public static final int FUEL_CONSUMPTION = 12;
    public static final float HARDNESS_MULTIPLER = 8.0f;
    protected static final int WATCHER_ID_FUEL = 16;
    protected static final int WATCHER_ID_MOVING = 25;
    protected static final int WATCHER_ID_BORE_HEAD = 26;
    protected static final int WATCHER_ID_FACING = 5;
    protected boolean degreeCalc = false;
    protected int delay = 0;
    private boolean active;
    private int update;
    private int burnTime;
    private int fuel;
    private boolean hasInit = true;
    protected boolean placeRail = false;
    protected boolean placeBallast = false;
    protected boolean boreLayer = false;
    protected final IInventory invFuel = new InventoryMapper(this, 1, 6);
    protected final IInventory invBallast = new InventoryMapper(this, 7, 9);
    protected final IInventory invRails = new InventoryMapper(this, 16, 9);
    protected int boreRotationAngle = 0;
    private static final Set mineableBlocks = new HashSet();
    private static final int[] mineable = new int[]{Block.field_72041_aW.field_71990_ca, Block.field_72039_aU.field_71990_ca, Block.field_72038_aV.field_71990_ca, Block.field_82513_cg.field_71990_ca, Block.field_71978_w.field_71990_ca, Block.field_72087_ao.field_71990_ca, Block.field_72086_bP.field_71990_ca, Block.field_72058_az.field_71990_ca, Block.field_71961_Y.field_71990_ca, Block.field_71979_v.field_71990_ca, Block.field_72067_ar.field_71990_ca, Block.field_72014_bd.field_71990_ca, Block.field_71980_u.field_71990_ca, Block.field_71940_F.field_71990_ca, Block.field_72036_aT.field_71990_ca, Block.field_71952_K.field_71990_ca, Block.field_71997_br.field_71990_ca, Block.field_71999_bt.field_71990_ca, Block.field_72109_af.field_71990_ca, Block.field_72000_bn.field_71990_ca, Block.field_72001_bo.field_71990_ca, Block.field_72103_ag.field_71990_ca, Block.field_71994_by.field_71990_ca, Block.field_72094_bD.field_71990_ca, Block.field_72012_bb.field_71990_ca, Block.field_72089_ap.field_71990_ca, Block.field_71950_I.field_71990_ca, Block.field_72073_aw.field_71990_ca, Block.field_72068_bR.field_71990_ca, Block.field_71941_G.field_71990_ca, Block.field_71949_H.field_71990_ca, Block.field_71947_N.field_71990_ca, Block.field_72047_aN.field_71990_ca, Block.field_72048_aO.field_71990_ca, Block.field_72107_ae.field_71990_ca, Block.field_72097_ad.field_71990_ca, Block.field_82514_ch.field_71990_ca, Block.field_72061_ba.field_71990_ca, Block.field_71996_bs.field_71990_ca, Block.field_72040_aX.field_71990_ca, Block.field_71939_E.field_71990_ca, Block.field_71957_Q.field_71990_ca, Block.field_71987_y.field_71990_ca, Block.field_72013_bc.field_71990_ca, Block.field_72037_aS.field_71990_ca, Block.field_71981_t.field_71990_ca, Block.field_71962_X.field_71990_ca, Block.field_72050_aA.field_71990_ca, Block.field_72069_aq.field_71990_ca, Block.field_71998_bu.field_71990_ca, Block.field_71991_bz.field_71990_ca, Block.field_71955_W.field_71990_ca, Block.field_72082_bJ.field_71990_ca, Block.field_71951_J.field_71990_ca};
    public static final Set replaceableBlocks = new HashSet();
    private static final int[] replaceable = new int[]{Block.field_72069_aq.field_71990_ca, Block.field_71962_X.field_71990_ca, Block.field_71961_Y.field_71990_ca, Block.field_71998_bu.field_71990_ca, Block.field_72109_af.field_71990_ca, Block.field_72103_ag.field_71990_ca, Block.field_72097_ad.field_71990_ca, Block.field_72107_ae.field_71990_ca};

    public EntityTunnelBore(World world, double i, double j, double k) {
        this(world, i, j, k, ForgeDirection.SOUTH);
    }

    public EntityTunnelBore(World world, double i, double j, double k, ForgeDirection f) {
        super(world);
        this.func_70107_b(i, j + (double)this.field_70129_M, k);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = i;
        this.field_70167_r = j;
        this.field_70166_s = k;
        this.setFacing(f);
        this.func_70105_a(6.0f, 2.7f);
        this.update = MiscTools.getRand().nextInt();
    }

    public EntityTunnelBore(World world) {
        this(world, 0.0, 0.0, 0.0, ForgeDirection.SOUTH);
    }

    public static void addMineableBlock(int id) {
        EntityTunnelBore.addMineableBlock(id, -1);
    }

    public static void addMineableBlock(int id, int meta) {
        mineableBlocks.add(new Mineable(id, meta));
    }

    private boolean isMinableBlock(int id, int meta) {
        if (RailcraftConfig.boreMinesAllBlocks()) {
            return true;
        }
        Mineable mine = new Mineable(id, -1);
        if (mineableBlocks.contains(mine)) {
            return true;
        }
        mine.meta = meta;
        return mineableBlocks.contains(mine);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)-1);
        this.field_70180_af.func_75682_a(5, (Object)0);
    }

    public boolean isMinecartPowered() {
        return this.field_70180_af.func_75683_a(16) != 0;
    }

    public void setMinecartPowered(boolean powered) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(powered ? 1 : 0)));
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (this.func_85032_ar()) {
                return false;
            }
            this.func_70494_i(-this.func_70493_k());
            this.func_70497_h(10);
            this.func_70018_K();
            this.func_70492_c(this.func_70491_i() + damage * 10.0f);
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.func_70491_i() > 120.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                if (flag && !this.func_94042_c()) {
                    this.func_70106_y();
                } else {
                    this.func_94095_a(source);
                }
            }
            return true;
        }
        return true;
    }

    private void setYaw() {
        float yaw = 0.0f;
        switch (this.getFacing()) {
            case NORTH: {
                yaw = 90.0f;
                break;
            }
            case EAST: {
                yaw = 0.0f;
                break;
            }
            case SOUTH: {
                yaw = 270.0f;
                break;
            }
            case WEST: {
                yaw = 180.0f;
            }
        }
        this.func_70101_b(yaw, this.field_70125_A);
    }

    public int func_70302_i_() {
        return 25;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70107_b(double i, double j, double k) {
        if (!this.hasInit) {
            super.func_70107_b(i, j, k);
            return;
        }
        this.field_70165_t = i;
        this.field_70163_u = j;
        this.field_70161_v = k;
        double w = 1.35;
        double h = 2.7;
        double l = 3.0;
        double x1 = i;
        double x2 = i;
        double z1 = k;
        double z2 = k;
        if (this.getFacing() == ForgeDirection.WEST || this.getFacing() == ForgeDirection.EAST) {
            x1 -= l;
            x2 += l;
            z1 -= w;
            z2 += w;
        } else {
            x1 -= w;
            x2 += w;
            z1 -= l;
            z2 += l;
        }
        this.field_70121_D.func_72324_b(x1, j - (double)this.field_70129_M + (double)this.field_70139_V, z1, x2, j - (double)this.field_70129_M + (double)this.field_70139_V + h, z2);
    }

    public void func_70071_h_() {
        ++this.update;
        if (Game.isHost(this.field_70170_p)) {
            if (this.update % 128 == 0) {
                this.forceUpdateBoreHead();
                this.setMinecartPowered(false);
                this.setMoving(false);
            } else {
                this.updateBoreHead();
            }
            this.stockBallast();
            this.stockTracks();
        }
        super.func_70071_h_();
        if (Game.isHost(this.field_70170_p)) {
            this.updateFuel();
            if (this.hasFuel() && this.getDelay() == 0) {
                boolean placed;
                int z;
                int x;
                float offset;
                this.setActive(true);
                int y = MathHelper.func_76128_c((double)this.field_70163_u);
                EnumTrackMeta dir = EnumTrackMeta.NORTH_SOUTH;
                if (this.getFacing() == ForgeDirection.WEST || this.getFacing() == ForgeDirection.EAST) {
                    dir = EnumTrackMeta.EAST_WEST;
                }
                if (this.getDelay() == 0) {
                    offset = 1.5f;
                    x = MathHelper.func_76128_c((double)this.getXAhead(this.field_70165_t, offset));
                    z = MathHelper.func_76128_c((double)this.getZAhead(this.field_70161_v, offset));
                    if (this.placeBallast) {
                        placed = this.placeBallast(x, y - 1, z);
                        if (placed) {
                            this.setDelay(5);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.placeBallast = false;
                    } else if (!this.field_70170_p.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP)) {
                        this.placeBallast = true;
                        this.setDelay(10);
                    }
                }
                if (this.getDelay() == 0) {
                    offset = 0.8f;
                    x = MathHelper.func_76128_c((double)this.getXAhead(this.field_70165_t, offset));
                    z = MathHelper.func_76128_c((double)this.getZAhead(this.field_70161_v, offset));
                    if (this.placeRail) {
                        placed = this.placeTrack(x, y, z, dir);
                        if (placed) {
                            this.setDelay(5);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.placeRail = false;
                    } else if (TrackTools.isRailBlockAt(this.field_70170_p, x, y, z)) {
                        if (!dir.isEqual(TrackTools.getTrackMeta(this.field_70170_p, (EntityMinecart)this, x, y, z))) {
                            this.field_70170_p.func_72921_c(x, y, z, dir.ordinal(), 3);
                            this.setDelay(5);
                        }
                    } else if (this.field_70170_p.func_72799_c(x, y, z) || replaceableBlocks.contains(this.field_70170_p.func_72798_a(x, y, z))) {
                        this.placeRail = true;
                        this.setDelay(5);
                    } else {
                        this.setDelay(200);
                        this.setActive(false);
                    }
                }
                if (this.getDelay() == 0) {
                    offset = 3.3f;
                    x = MathHelper.func_76128_c((double)this.getXAhead(this.field_70165_t, offset));
                    z = MathHelper.func_76128_c((double)this.getZAhead(this.field_70161_v, offset));
                    if (this.boreLayer) {
                        boolean bored = this.boreLayer(x, y, z, dir);
                        if (bored) {
                            this.setDelay(40);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.boreLayer = false;
                    } else if (this.checkForLava(x, y, z, dir)) {
                        this.setDelay(200);
                        this.setActive(false);
                    } else {
                        this.setDelay((int)Math.ceil(this.getLayerHardness(x, y, z, dir)));
                        if (this.getDelay() != 0) {
                            this.boreLayer = true;
                        }
                    }
                }
            }
            if (this.isMinecartPowered()) {
                double i = this.getXAhead(this.field_70165_t, 3.3);
                double k = this.getZAhead(this.field_70161_v, 3.3);
                double size = 0.8;
                List entities = this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72332_a().func_72299_a(i - size, this.field_70163_u, k - size, i + size, this.field_70163_u + 2.0, k + size));
                for (Object e : entities) {
                    if (!(e instanceof EntityLivingBase)) continue;
                    EntityLivingBase ent = (EntityLivingBase)e;
                    ent.func_70097_a((DamageSource)DamageSourceBore.INSTANCE, 2.0f);
                }
            }
            this.setMoving(this.hasFuel() && this.getDelay() == 0);
            if (this.getDelay() > 0) {
                this.setDelay(this.getDelay() - 1);
            }
        }
        if (this.isMoving()) {
            float factorX = MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z)));
            float factorZ = -MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z)));
            this.field_70159_w = 0.03f * factorX;
            this.field_70179_y = 0.03f * factorZ;
        } else {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        this.emitParticles();
        if (this.isMinecartPowered()) {
            this.boreRotationAngle += 5;
        }
    }

    public float getMaxCartSpeedOnRail() {
        return 0.03f;
    }

    private void updateFuel() {
        if (Game.isHost(this.field_70170_p)) {
            if (this.isMinecartPowered()) {
                this.spendFuel();
            }
            this.stockFuel();
            if (this.outOfFuel()) {
                this.addFuel();
            }
            this.setMinecartPowered(this.hasFuel() && this.isActive());
        }
    }

    protected double getXAhead(double x, double offset) {
        if (this.getFacing() == ForgeDirection.EAST) {
            x += offset;
        } else if (this.getFacing() == ForgeDirection.WEST) {
            x -= offset;
        }
        return x;
    }

    protected double getZAhead(double z, double offset) {
        if (this.getFacing() == ForgeDirection.NORTH) {
            z -= offset;
        } else if (this.getFacing() == ForgeDirection.SOUTH) {
            z += offset;
        }
        return z;
    }

    protected void emitParticles() {
        if (this.isMinecartPowered()) {
            double randomFactor = 0.125;
            double forwardOffset = -0.35;
            double smokeYOffset = 2.4;
            double flameYOffset = 0.7;
            double smokeSideOffset = 0.92;
            double flameSideOffset = 1.14;
            double smokeX1 = this.field_70165_t;
            double smokeX2 = this.field_70165_t;
            double smokeZ1 = this.field_70161_v;
            double smokeZ2 = this.field_70161_v;
            double flameX1 = this.field_70165_t;
            double flameX2 = this.field_70165_t;
            double flameZ1 = this.field_70161_v;
            double flameZ2 = this.field_70161_v;
            if (this.getFacing() == ForgeDirection.NORTH) {
                smokeX1 += smokeSideOffset;
                smokeX2 -= smokeSideOffset;
                smokeZ1 += forwardOffset;
                smokeZ2 += forwardOffset;
                flameX1 += flameSideOffset;
                flameX2 -= flameSideOffset;
                flameZ1 += forwardOffset + this.field_70146_Z.nextGaussian() * randomFactor;
                flameZ2 += forwardOffset + this.field_70146_Z.nextGaussian() * randomFactor;
            } else if (this.getFacing() == ForgeDirection.EAST) {
                smokeX1 -= forwardOffset;
                smokeX2 -= forwardOffset;
                smokeZ1 += smokeSideOffset;
                smokeZ2 -= smokeSideOffset;
                flameX1 -= forwardOffset + this.field_70146_Z.nextGaussian() * randomFactor;
                flameX2 -= forwardOffset + this.field_70146_Z.nextGaussian() * randomFactor;
                flameZ1 += flameSideOffset;
                flameZ2 -= flameSideOffset;
            } else if (this.getFacing() == ForgeDirection.SOUTH) {
                smokeX1 += smokeSideOffset;
                smokeX2 -= smokeSideOffset;
                smokeZ1 -= forwardOffset;
                smokeZ2 -= forwardOffset;
                flameX1 += flameSideOffset;
                flameX2 -= flameSideOffset;
                flameZ1 -= forwardOffset + this.field_70146_Z.nextGaussian() * randomFactor;
                flameZ2 -= forwardOffset + this.field_70146_Z.nextGaussian() * randomFactor;
            } else if (this.getFacing() == ForgeDirection.WEST) {
                smokeX1 += forwardOffset;
                smokeX2 += forwardOffset;
                smokeZ1 += smokeSideOffset;
                smokeZ2 -= smokeSideOffset;
                flameX1 += forwardOffset + this.field_70146_Z.nextGaussian() * randomFactor;
                flameX2 += forwardOffset + this.field_70146_Z.nextGaussian() * randomFactor;
                flameZ1 += flameSideOffset;
                flameZ2 -= flameSideOffset;
            }
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.field_70170_p.func_72869_a("largesmoke", smokeX1, this.field_70163_u + smokeYOffset, smokeZ1, 0.0, 0.0, 0.0);
                this.field_70170_p.func_72869_a("flame", flameX1, this.field_70163_u + flameYOffset + this.field_70146_Z.nextGaussian() * randomFactor, flameZ1, 0.0, 0.0, 0.0);
            }
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.field_70170_p.func_72869_a("largesmoke", smokeX2, this.field_70163_u + smokeYOffset, smokeZ2, 0.0, 0.0, 0.0);
                this.field_70170_p.func_72869_a("flame", flameX2, this.field_70163_u + flameYOffset + this.field_70146_Z.nextGaussian() * randomFactor, flameZ2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void stockBallast() {
        EntityMinecart link = LinkageManager.instance().getLinkedCartA((EntityMinecart)this);
        if (link instanceof IItemTransfer) {
            IItemTransfer tranfer = (IItemTransfer)link;
            for (int slot = 0; slot < this.invBallast.func_70302_i_(); ++slot) {
                ItemStack stack = this.invBallast.func_70301_a(slot);
                if (stack != null && !BallastRegistry.isItemBallast(stack)) {
                    stack = tranfer.offerItem(this, stack);
                    this.invBallast.func_70299_a(slot, stack);
                    return;
                }
                if (stack != null) continue;
                stack = tranfer.requestItem((Object)this, StackFilter.BALLAST);
                InvTools.moveItemStack(stack, this.invBallast);
                return;
            }
        }
    }

    protected boolean placeBallast(int i, int j, int k) {
        if (!this.field_70170_p.isBlockSolidOnSide(i, j, k, ForgeDirection.UP)) {
            for (int inv = 0; inv < this.invBallast.func_70302_i_(); ++inv) {
                ItemStack stack = this.invBallast.func_70301_a(inv);
                if (stack == null || !BallastRegistry.isItemBallast(stack)) continue;
                for (int y = j; y > j - 10; --y) {
                    if (!this.field_70170_p.isBlockSolidOnSide(i, y, k, ForgeDirection.UP)) continue;
                    this.invBallast.func_70298_a(inv, 1);
                    this.field_70170_p.func_72832_d(i, j, k, stack.field_77993_c, stack.func_77960_j(), 3);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected void stockTracks() {
        EntityMinecart link = LinkageManager.instance().getLinkedCartA((EntityMinecart)this);
        if (link instanceof IItemTransfer) {
            IItemTransfer tranfer = (IItemTransfer)link;
            for (int slot = 0; slot < this.invRails.func_70302_i_(); ++slot) {
                ItemStack stack = this.invRails.func_70301_a(slot);
                if (stack != null && !StackFilter.TRACK.matches(stack)) {
                    stack = tranfer.offerItem(this, stack);
                    this.invRails.func_70299_a(slot, stack);
                    return;
                }
                if (stack != null) continue;
                stack = tranfer.requestItem((Object)this, StackFilter.TRACK);
                InvTools.moveItemStack(stack, this.invRails);
                return;
            }
        }
    }

    protected boolean placeTrack(int x, int y, int z, EnumTrackMeta meta) {
        int id = this.field_70170_p.func_72798_a(x, y, z);
        if (replaceableBlocks.contains(id)) {
            this.field_70170_p.func_94578_a(x, y, z, true);
        }
        if (this.field_70170_p.func_72799_c(x, y, z) && this.field_70170_p.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP)) {
            for (int inv = 0; inv < this.invRails.func_70302_i_(); ++inv) {
                ItemStack stack = this.invRails.func_70301_a(inv);
                if (stack == null) continue;
                boolean placed = RailTools.placeRailAt(stack, this.field_70170_p, x, y, z);
                if (placed) {
                    this.field_70170_p.func_72921_c(x, y, z, meta.ordinal(), 3);
                    this.invRails.func_70298_a(inv, 1);
                }
                return placed;
            }
        }
        return false;
    }

    protected boolean checkForLava(int i, int j, int k, EnumTrackMeta dir) {
        int xStart = i - 1;
        int zStart = k - 1;
        int xEnd = i + 1;
        int zEnd = k + 1;
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            xStart = i - 2;
            xEnd = i + 2;
        } else {
            zStart = k - 2;
            zEnd = k + 2;
        }
        for (int jj = j; jj < j + 4; ++jj) {
            for (int ii = xStart; ii <= xEnd; ++ii) {
                for (int kk = zStart; kk <= zEnd; ++kk) {
                    int id = this.field_70170_p.func_72798_a(ii, jj, kk);
                    if (id != Block.field_71938_D.field_71990_ca && id != Block.field_71944_C.field_71990_ca) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean boreLayer(int i, int j, int k, EnumTrackMeta dir) {
        int jj;
        boolean clear = true;
        int ii = i;
        int kk = k;
        for (jj = j; jj < j + 3; ++jj) {
            clear = clear && this.mineBlock(ii, jj, kk, dir);
        }
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            --ii;
        } else {
            --kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            clear = clear && this.mineBlock(ii, jj, kk, dir);
        }
        ii = i;
        kk = k;
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            ++ii;
        } else {
            ++kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            clear = clear && this.mineBlock(ii, jj, kk, dir);
        }
        return clear;
    }

    protected boolean mineBlock(int x, int y, int z, EnumTrackMeta dir) {
        int trackMeta;
        if (this.field_70170_p.func_72799_c(x, y, z)) {
            return true;
        }
        int id = this.field_70170_p.func_72798_a(x, y, z);
        if (TrackTools.isRailBlock(id) ? dir.isEqual(trackMeta = TrackTools.getTrackMeta(this.field_70170_p, id, (EntityMinecart)this, x, y, z)) : id == Block.field_72069_aq.field_71990_ca) {
            return true;
        }
        ItemStack head = this.func_70301_a(0);
        if (head == null) {
            return false;
        }
        int meta = this.field_70170_p.func_72805_g(x, y, z);
        if (!this.canMineBlock(x, y, z, id, meta)) {
            return false;
        }
        Block block = Block.field_71973_m[id];
        ArrayList items = block.getBlockDropped(this.field_70170_p, x, y, z, meta, 0);
        EntityMinecart link = LinkageManager.instance().getLinkedCartA((EntityMinecart)this);
        for (ItemStack item : items) {
            if (StackFilter.FUEL.matches(item)) {
                item = InvTools.moveItemStack(item, this.invFuel);
            }
            if (item != null && item.field_77994_a > 0 && item.field_77993_c == Block.field_71940_F.field_71990_ca) {
                item = InvTools.moveItemStack(item, this.invBallast);
            }
            if (item != null && item.field_77994_a > 0 && link instanceof IItemTransfer) {
                item = ((IItemTransfer)link).offerItem(this, item);
            }
            if (item == null || item.field_77994_a <= 0 || RailcraftConfig.boreDestroysBlocks()) continue;
            float f = 0.7f;
            double xr = ((double)this.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)f;
            double yr = ((double)this.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)f;
            double zr = ((double)this.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)f;
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.getXAhead(this.field_70165_t, -3.2) + xr, this.field_70163_u + 0.3 + yr, this.getZAhead(this.field_70161_v, -3.2) + zr, item);
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
        this.field_70170_p.func_94571_i(x, y, z);
        head.func_77964_b(head.func_77960_j() + 1);
        if (head.func_77960_j() > head.func_77958_k()) {
            this.func_70299_a(0, null);
        }
        return true;
    }

    private boolean canMineBlock(int i, int j, int k, int id, int meta) {
        Block block = Block.field_71973_m[id];
        ItemStack head = this.func_70301_a(0);
        if (block instanceof IMineable) {
            if (head == null) {
                return false;
            }
            return ((IMineable)block).canMineBlock(this.field_70170_p, i, j, k, (EntityMinecart)this, head);
        }
        if (block.func_71934_m(this.field_70170_p, i, j, k) < 0.0f) {
            return false;
        }
        return this.isMinableBlock(id, meta) && EntityTunnelBore.canHeadHarvestBlock(head, id, meta);
    }

    public static boolean canHeadHarvestBlock(ItemStack head, int id, int meta) {
        if (head == null) {
            return false;
        }
        if (head.func_77973_b() instanceof IBoreHead) {
            IBoreHead boreHead = (IBoreHead)head.func_77973_b();
            boolean mappingExists = false;
            int blockHarvestLevel = MinecraftForge.getBlockHarvestLevel((Block)Block.field_71973_m[id], (int)meta, (String)"pickaxe");
            if (blockHarvestLevel > -1) {
                if (boreHead.getHarvestLevel() >= blockHarvestLevel) {
                    return true;
                }
                mappingExists = true;
            }
            if ((blockHarvestLevel = MinecraftForge.getBlockHarvestLevel((Block)Block.field_71973_m[id], (int)meta, (String)"axe")) > -1) {
                if (boreHead.getHarvestLevel() >= blockHarvestLevel) {
                    return true;
                }
                mappingExists = true;
            }
            if ((blockHarvestLevel = MinecraftForge.getBlockHarvestLevel((Block)Block.field_71973_m[id], (int)meta, (String)"shovel")) > -1) {
                if (boreHead.getHarvestLevel() >= blockHarvestLevel) {
                    return true;
                }
                mappingExists = true;
            }
            if (mappingExists) {
                return false;
            }
        }
        return true;
    }

    protected float getLayerHardness(int i, int j, int k, EnumTrackMeta dir) {
        int jj;
        float hardness = 0.0f;
        int ii = i;
        int kk = k;
        for (jj = j; jj < j + 3; ++jj) {
            hardness += this.getBlockHardness(ii, jj, kk, dir);
        }
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            --ii;
        } else {
            --kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            hardness += this.getBlockHardness(ii, jj, kk, dir);
        }
        ii = i;
        kk = k;
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            ++ii;
        } else {
            ++kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            hardness += this.getBlockHardness(ii, jj, kk, dir);
        }
        hardness *= 8.0f;
        ItemStack boreSlot = this.func_70301_a(0);
        if (boreSlot != null && boreSlot.func_77973_b() instanceof IBoreHead) {
            IBoreHead head = (IBoreHead)boreSlot.func_77973_b();
            float dig = 2.0f - head.getDigModifier();
            hardness *= dig;
        }
        return hardness;
    }

    protected float getBlockHardness(int x, int y, int z, EnumTrackMeta dir) {
        int trackMeta;
        if (this.field_70170_p.func_72799_c(x, y, z)) {
            return 0.0f;
        }
        int id = this.field_70170_p.func_72798_a(x, y, z);
        if (TrackTools.isRailBlock(id) && dir.isEqual(trackMeta = TrackTools.getTrackMeta(this.field_70170_p, id, (EntityMinecart)this, x, y, z))) {
            return 0.0f;
        }
        if (id == Block.field_72069_aq.field_71990_ca) {
            return 0.0f;
        }
        if (id == Block.field_72089_ap.field_71990_ca) {
            return 15.0f;
        }
        int meta = this.field_70170_p.func_72805_g(x, y, z);
        if (!this.canMineBlock(x, y, z, id, meta)) {
            return 0.1f;
        }
        float hardness = Block.field_71973_m[id].func_71934_m(this.field_70170_p, x, y, z);
        if (hardness <= 0.0f) {
            hardness = 0.1f;
        }
        return hardness;
    }

    public AxisAlignedBB func_70114_g(Entity other) {
        if (other instanceof EntityLivingBase) {
            return other.field_70121_D;
        }
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public String func_70303_b() {
        return "Tunnel Bore";
    }

    public float getBoreRotationAngle() {
        return (float)Math.toRadians(this.boreRotationAngle);
    }

    protected void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        data.func_74774_a("facing", (byte)this.getFacing().ordinal());
        data.func_74768_a("delay", this.getDelay());
        data.func_74757_a("active", this.isActive());
        data.func_74768_a("burnTime", this.getBurnTime());
        data.func_74768_a("fuel", this.fuel);
    }

    protected void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        this.setFacing(ForgeDirection.getOrientation((int)data.func_74771_c("facing")));
        this.setDelay(data.func_74762_e("delay"));
        this.setActive(data.func_74767_n("active"));
        this.setBurnTime(data.func_74762_e("burnTime"));
        this.setFuel(data.func_74762_e("fuel"));
        this.update = MiscTools.getRand().nextInt();
    }

    protected void setDelay(int i) {
        this.delay = i;
    }

    protected int getDelay() {
        return this.delay;
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    protected boolean isMoving() {
        return this.field_70180_af.func_75683_a(25) != 0;
    }

    protected void setMoving(boolean move) {
        this.field_70180_af.func_75692_b(25, (Object)((byte)(move ? 1 : 0)));
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getFuel() {
        return this.fuel;
    }

    public boolean outOfFuel() {
        return this.getFuel() <= 12;
    }

    public boolean hasFuel() {
        return this.getFuel() > 0;
    }

    protected void stockFuel() {
        EntityMinecart link = LinkageManager.instance().getLinkedCartA((EntityMinecart)this);
        if (link instanceof IItemTransfer) {
            IItemTransfer tranfer = (IItemTransfer)link;
            for (int slot = 0; slot < this.invFuel.func_70302_i_(); ++slot) {
                ItemStack stack = this.invFuel.func_70301_a(slot);
                if (stack != null && !StackFilter.FUEL.matches(stack)) {
                    stack = tranfer.offerItem(this, stack);
                    this.invFuel.func_70299_a(slot, stack);
                    return;
                }
                if (stack != null || (stack = tranfer.requestItem((Object)this, StackFilter.FUEL)) == null) continue;
                InvTools.moveItemStack(stack, this.invFuel);
                return;
            }
        }
    }

    protected void addFuel() {
        int burn = 0;
        for (int slot = 0; slot < this.invFuel.func_70302_i_(); ++slot) {
            ItemStack stack = this.invFuel.func_70301_a(slot);
            if (stack == null || (burn = FuelPlugin.getBurnTime(stack)) <= 0) continue;
            if (stack.func_77973_b().func_77634_r()) {
                this.invFuel.func_70299_a(slot, stack.func_77973_b().getContainerItemStack(stack));
                break;
            }
            this.invFuel.func_70298_a(slot, 1);
            break;
        }
        if (burn > 0) {
            this.setBurnTime(burn + this.getFuel());
            this.setFuel(this.getFuel() + burn);
        }
    }

    public int getBurnProgressScaled(int i) {
        int burn = this.getBurnTime();
        if (burn == 0) {
            return 0;
        }
        return this.getFuel() * i / burn;
    }

    public void setFuel(int i) {
        this.fuel = i;
    }

    protected void spendFuel() {
        this.setFuel(this.getFuel() - 12);
    }

    protected void updateBoreHead() {
        int id = -1;
        ItemStack boreSlot = this.func_70301_a(0);
        if (boreSlot != null) {
            id = boreSlot.field_77993_c;
        }
        this.field_70180_af.func_75692_b(26, (Object)id);
    }

    protected void forceUpdateBoreHead() {
        this.field_70180_af.func_75692_b(26, (Object)-1);
        this.updateBoreHead();
    }

    public IBoreHead getBoreHead() {
        int id = this.field_70180_af.func_75679_c(26);
        IBoreHead head = null;
        if (id > 0 && id < Item.field_77698_e.length && Item.field_77698_e[id] instanceof IBoreHead) {
            head = (IBoreHead)Item.field_77698_e[id];
        }
        return head;
    }

    protected void func_94101_h() {
        this.field_70159_w *= this.getDrag();
        this.field_70181_x *= 0.0;
        this.field_70179_y *= this.getDrag();
    }

    @Override
    public List getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    public boolean isPoweredCart() {
        return true;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            GuiHandler.openGui(EnumGui.CART_BORE, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    public void func_70296_d() {
        if (!this.isActive()) {
            this.setDelay(5);
        }
    }

    public final ForgeDirection getFacing() {
        return ForgeDirection.getOrientation((int)this.field_70180_af.func_75683_a(5));
    }

    protected final void setFacing(ForgeDirection facing) {
        this.field_70180_af.func_75692_b(5, (Object)((byte)facing.ordinal()));
        this.setYaw();
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    @Override
    public boolean canLinkWithCart(EntityMinecart cart) {
        double z;
        double x = this.getXAhead(this.field_70165_t, -3.0);
        return cart.func_70011_f(x, this.field_70163_u, z = this.getZAhead(this.field_70161_v, -3.0)) < 2.5;
    }

    @Override
    public boolean hasTwoLinks() {
        return false;
    }

    @Override
    public float getLinkageDistance(EntityMinecart cart) {
        return 4.0f;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        return 3.1f;
    }

    @Override
    public void onLinkCreated(EntityMinecart cart) {
    }

    @Override
    public void onLinkBroken(EntityMinecart cart) {
    }

    @Override
    public boolean canBeAdjusted(EntityMinecart cart) {
        return false;
    }

    public boolean shouldDoRailFunctions() {
        return false;
    }

    public IInventory getInventoryFuel() {
        return this.invFuel;
    }

    public IInventory getInventoryGravel() {
        return this.invBallast;
    }

    public IInventory getInventoryRails() {
        return this.invRails;
    }

    static {
        for (int id : mineable) {
            EntityTunnelBore.addMineableBlock(id);
        }
        for (int id : replaceable) {
            replaceableBlocks.add(id);
        }
    }

    private static class Mineable {
        public int id;
        public int meta;

        public Mineable(int id, int meta) {
            this.id = id;
            this.meta = meta;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mineable other = (Mineable)obj;
            if (this.id != other.id) {
                return false;
            }
            return this.meta == other.meta;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + this.id;
            hash = 41 * hash + this.meta;
            return hash;
        }
    }
}

