/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.util.HashMap;
import java.util.Map;
import mods.railcraft.api.core.ITextureLoader;
import mods.railcraft.api.tracks.ITrackItemIconProvider;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;

public class TrackTextureLoader
implements ITextureLoader,
ITrackItemIconProvider {
    public static final TrackTextureLoader INSTANCE = new TrackTextureLoader();
    public final Map textures = new HashMap();
    public final Map itemIcon = new HashMap();

    @Override
    public void registerIcons(IconRegister iconRegister) {
        for (EnumTrack track : EnumTrack.VALUES) {
            if (track.getNumIcons() == 0) continue;
            Icon[] icons = TextureAtlasSheet.unstitchIcons(iconRegister, track.getTextureTag(), track.getNumIcons());
            this.textures.put(track.getTrackSpec(), icons);
            this.itemIcon.put(track.getTrackSpec(), icons[track.getItemIconIndex()]);
        }
    }

    @Override
    public Icon getTrackItemIcon(TrackSpec spec) {
        Icon icon = (Icon)this.itemIcon.get(spec);
        if (icon == null) {
            icon = Block.field_72056_aG.func_71858_a(0, 0);
        }
        return icon;
    }

    public Icon[] getTrackIcons(TrackSpec spec) {
        return (Icon[])this.textures.get(spec);
    }
}

