/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.api.core.ITextureLoader;
import mods.railcraft.api.tracks.ITrackBlocksMovement;
import mods.railcraft.api.tracks.ITrackCustomShape;
import mods.railcraft.api.tracks.ITrackEmitter;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.TrackRegistry;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TileTrackTESR;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockTrack
extends BlockRailBase
implements IPostConnection {
    protected final int renderType;

    public BlockTrack(int blockID, int modelID) {
        super(blockID, false);
        this.renderType = modelID;
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.func_71894_b(3.5f);
        this.func_71848_c(1.05f);
        this.func_71884_a(field_71977_i);
        this.func_71849_a(CreativeTabs.field_78029_e);
        GameRegistry.registerTileEntity(TileTrack.class, (String)"RailcraftTrackTile");
        GameRegistry.registerTileEntity(TileTrackTESR.class, (String)"RailcraftTrackTESRTile");
        try {
            TrackSpec.blockTrack = this;
        }
        catch (Throwable error) {
            Game.logErrorAPI(Railcraft.getModId(), error, TrackSpec.class);
        }
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        Map specs = TrackRegistry.getTrackSpecs();
        HashSet<TrackSpec> railcraftSpecs = new HashSet<TrackSpec>();
        for (EnumTrack track : EnumTrack.getCreativeList()) {
            TrackSpec spec = (TrackSpec)specs.get((short)track.ordinal());
            if (spec == null) continue;
            railcraftSpecs.add(spec);
            if (!track.isEnabled() || track.isDepreciated()) continue;
            list.add(spec.getItem());
        }
        HashSet otherSpecs = new HashSet(specs.values());
        otherSpecs.removeAll(railcraftSpecs);
        otherSpecs.remove(TrackRegistry.getTrackSpec(-1));
        for (TrackSpec spec : otherSpecs) {
            list.add(spec.getItem());
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileTrack) {
            ITrackInstance track = ((TileTrack)tile).getTrackInstance();
            return new ItemStack((Block)this, 1, (int)track.getTrackSpec().getTrackId());
        }
        return null;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        return false;
    }

    public int func_71857_b() {
        return this.renderType;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public int func_71915_e() {
        return 0;
    }

    public AxisAlignedBB func_71872_e(World world, int i, int j, int k) {
        ITrackInstance track;
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
            return ((ITrackCustomShape)track).getCollisionBoundingBoxFromPool();
        }
        return null;
    }

    public AxisAlignedBB func_71911_a_(World world, int i, int j, int k) {
        ITrackInstance track;
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
            return ((ITrackCustomShape)track).getSelectedBoundingBoxFromPool();
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)i + this.field_72026_ch, (double)j + this.field_72023_ci, (double)k + this.field_72024_cj, (double)i + this.field_72021_ck, (double)j + this.field_72022_cl, (double)k + this.field_72019_cm);
    }

    public boolean func_71926_d() {
        return false;
    }

    public MovingObjectPosition func_71878_a(World world, int i, int j, int k, Vec3 vec3d, Vec3 vec3d1) {
        ITrackInstance track;
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
            return ((ITrackCustomShape)track).collisionRayTrace(vec3d, vec3d1);
        }
        return super.func_71878_a(world, i, j, k, vec3d, vec3d1);
    }

    public void func_71902_a(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.func_72805_g(i, j, k);
        if (l >= 2 && l <= 5) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    public boolean func_71918_c(IBlockAccess world, int x, int y, int z) {
        ITrackInstance track;
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackBlocksMovement) {
            return !((ITrackBlocksMovement)((Object)track)).blocksMovement();
        }
        return super.func_71918_c(world, x, y, z);
    }

    public boolean func_71930_b(World world, int i, int j, int k) {
        return !BlockRailBase.func_72180_d_((World)world, (int)i, (int)(j + 1), (int)k);
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71853_i() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileTrack) {
            ITrackInstance track = ((TileTrack)tile).getTrackInstance();
            return track instanceof ITrackEmitter;
        }
        return false;
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileTrack) {
            ITrackInstance track = ((TileTrack)tile).getTrackInstance();
            return track instanceof ITrackEmitter ? ((ITrackEmitter)track).getPowerOutput() : 0;
        }
        return 0;
    }

    public void onMinecartPass(World world, EntityMinecart cart, int i, int j, int k) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack) {
            ((TileTrack)tile).getTrackInstance().onMinecartPass(cart);
        }
    }

    public int getBasicRailMetadata(IBlockAccess world, EntityMinecart cart, int i, int j, int k) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getBasicRailMetadata(cart);
        }
        return world.func_72805_g(i, j, k);
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, int i, int j, int k) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getRailMaxSpeed(cart);
        }
        return 0.4f;
    }

    public boolean func_71903_a(World world, int i, int j, int k, EntityPlayer player, int side, float u1, float u2, float u3) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().blockActivated(player);
        }
        return false;
    }

    public boolean isFlexibleRail(World world, int i, int j, int k) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().isFlexibleRail();
        }
        return false;
    }

    public boolean canMakeSlopes(World world, int i, int j, int k) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().canMakeSlopes();
        }
        return true;
    }

    public Icon func_71858_a(int side, int meta) {
        return Block.field_72056_aG.func_71858_a(side, meta);
    }

    public Icon func_71895_b(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getIcon();
        }
        return null;
    }

    public void func_94332_a(IconRegister iconRegister) {
        for (ITextureLoader iconLoader : TrackRegistry.getIconLoaders()) {
            iconLoader.registerIcons(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addBlockHitEffects(worldObj, RailcraftBlocks.getBlockTrack(), target, effectRenderer, null);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addBlockDestroyEffects(worldObj, RailcraftBlocks.getBlockTrack(), x, y, z, meta, effectRenderer, null);
    }

    public ArrayList getBlockDropped(World world, int i, int j, int k, int md, int fortune) {
        TileEntity tile = world.func_72796_p(i, j, k);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tile instanceof TileTrack) {
            items.add(new ItemStack((Block)this, 1, (int)((TileTrack)tile).getTrackInstance().getTrackSpec().getTrackId()));
        } else {
            Game.log(Level.WARNING, "Rail Tile was invalid when harvesting rail", new Object[0]);
            items.add(new ItemStack(Block.field_72056_aG));
        }
        return items;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public int func_71885_a(int i, Random random, int j) {
        Game.log(Level.WARNING, "Wrong function called when harvesting rail", new Object[0]);
        return Block.field_72056_aG.func_71885_a(i, random, j);
    }

    public TileEntity getBlockEntity(int md) {
        return null;
    }

    public void func_71860_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack) {
            ((TileTrack)tile).onBlockPlacedBy(entityliving);
            ((TileTrack)tile).getTrackInstance().onBlockPlacedBy(entityliving);
        }
    }

    public void func_85105_g(World world, int i, int j, int k, int meta) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack) {
            ((TileTrack)tile).getTrackInstance().onBlockPlaced();
        }
    }

    public void func_71893_a(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71064_a(StatList.field_75934_C[this.field_71990_ca], 1);
        player.func_71020_j(0.025f);
        if (Game.isHost(world) && !player.field_71075_bZ.field_75098_d) {
            this.func_71897_c(world, x, y, z, 0, 0);
        }
        return world.func_94571_i(x, y, z);
    }

    public void func_71852_a(World world, int i, int j, int k, int id, int meta) {
        super.func_71852_a(world, i, j, k, id, meta);
        try {
            TileEntity tile = world.func_72796_p(i, j, k);
            if (tile instanceof TileTrack) {
                ((TileTrack)tile).getTrackInstance().onBlockRemoved();
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("Railcraft", error, ITrackInstance.class);
        }
        world.func_72932_q(i, j, k);
    }

    public void func_71863_a(World world, int i, int j, int k, int id) {
        if (Game.isNotHost(world)) {
            return;
        }
        TileEntity t = world.func_72796_p(i, j, k);
        if (t instanceof TileTrack) {
            TileTrack tile = (TileTrack)t;
            tile.getTrackInstance().onNeighborBlockChange(id);
        }
    }

    public float func_71934_m(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileTrack) {
            try {
                return ((TileTrack)tile).getTrackInstance().getHardness();
            }
            catch (Throwable error) {
                Game.logErrorAPI("Railcraft", error, ITrackInstance.class);
            }
        }
        return super.func_71934_m(world, x, y, z);
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double srcX, double srcY, double srcZ) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getExplosionResistance(srcX, srcY, srcZ, exploder) * 3.0f / 5.0f;
        }
        return this.func_71904_a(exploder);
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean connectsAt(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        ITrackInstance track;
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof IPostConnection) {
            return ((IPostConnection)((Object)track)).connectsAt(world, i, j, k, side);
        }
        return false;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        ITrackInstance track;
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof IPostConnection) {
            return ((IPostConnection)((Object)track)).connectsToPost(world, i, j, k, side);
        }
        return IPostConnection.ConnectStyle.NONE;
    }
}

