/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.common.blocks.signals.TileSignalFoundation;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileSwitchBase
extends TileSignalFoundation {
    private byte facing = (byte)ForgeDirection.NORTH.ordinal();
    private boolean powered;
    private ITrackSwitch switchTrack;
    private boolean lastSwitchState;

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        this.func_70311_o().func_71905_a(0.2f, 0.0f, 0.2f, 0.8f, 0.8f, 0.8f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)i + 0.2f), (double)j, (double)((float)k + 0.2f), (double)((float)i + 0.8f), (double)((float)j + 0.4f), (double)((float)k + 0.8f));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)i + 0.2f), (double)j, (double)((float)k + 0.2f), (double)((float)i + 0.8f), (double)((float)j + 0.8f), (double)((float)k + 0.8f));
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        this.powered = !this.powered;
        this.switchTrack(this.powered);
        return true;
    }

    @Override
    public void onBlockPlaced() {
        this.findTrack();
    }

    public ITrackSwitch getSwitchTrack() {
        if (this.switchTrack != null && this.switchTrack.getTile().func_70320_p()) {
            this.switchTrack = null;
        }
        if (this.switchTrack == null) {
            this.findTrack();
        }
        return this.switchTrack;
    }

    private void findTrack() {
        for (byte side = 2; side < 6; side = (byte)(side + 1)) {
            TileEntity tile = this.tileCache.getTileOnSide(ForgeDirection.getOrientation((int)side));
            if (tile instanceof TileTrack) {
                ITrackInstance track = ((TileTrack)tile).getTrackInstance();
                if (!(track instanceof ITrackSwitch)) continue;
                if (this.facing != side) {
                    this.facing = side;
                    this.markBlockForUpdate();
                }
                this.switchTrack = (ITrackSwitch)track;
                continue;
            }
            if (!(tile instanceof ITrackSwitch)) continue;
            if (this.facing != side) {
                this.facing = side;
                this.markBlockForUpdate();
            }
            this.switchTrack = (ITrackSwitch)tile;
        }
    }

    protected void switchTrack(boolean switched) {
        for (int side = 2; side < 6; side = (int)((byte)(side + 1))) {
            TileEntity tile = this.tileCache.getTileOnSide(ForgeDirection.getOrientation((int)side));
            if (tile instanceof TileTrack) {
                ITrackInstance track = ((TileTrack)tile).getTrackInstance();
                if (!(track instanceof ITrackSwitch)) continue;
                ((ITrackSwitch)track).setSwitched(switched);
                continue;
            }
            if (!(tile instanceof ITrackSwitch)) continue;
            ((ITrackSwitch)tile).setSwitched(switched);
        }
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        ITrackSwitch track = this.getSwitchTrack();
        if (track == null) {
            return;
        }
        boolean isSwitched = track.isSwitched();
        if (this.lastSwitchState != isSwitched) {
            this.lastSwitchState = isSwitched;
            if (isSwitched) {
                SoundHelper.playSound(this.field_70331_k, this.getX(), this.getY(), this.getZ(), "tile.piston.in", 0.25f, this.field_70331_k.field_73012_v.nextFloat() * 0.25f + 0.7f);
            } else {
                SoundHelper.playSound(this.field_70331_k, this.getX(), this.getY(), this.getZ(), "tile.piston.out", 0.25f, this.field_70331_k.field_73012_v.nextFloat() * 0.25f + 0.7f);
            }
            if (Game.isNotHost(this.field_70331_k)) {
                this.markBlockForUpdate();
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("Powered", this.isPowered());
        data.func_74757_a("lastSwitchState", this.lastSwitchState);
        data.func_74774_a("Facing", this.facing);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.powered = data.func_74767_n("Powered");
        this.lastSwitchState = data.func_74767_n("lastSwitchState");
        this.facing = data.func_74771_c("Facing");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.facing);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.facing = data.readByte();
        this.powered = data.readBoolean();
    }

    public byte getFacing() {
        return this.facing;
    }

    public void setFacing(byte facing) {
        this.facing = facing;
    }

    public boolean isPowered() {
        return this.powered;
    }

    protected void setPowered(boolean p) {
        this.powered = p;
    }

    protected boolean isBeingPoweredByRedstone() {
        return PowerPlugin.isBlockBeingPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n) || PowerPlugin.isRedstonePowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isSwitched() {
        ITrackSwitch track = this.getSwitchTrack();
        if (track == null) {
            return false;
        }
        return track.isSwitched();
    }
}

