/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.emblems.EmblemManager;
import mods.railcraft.common.emblems.ItemEmblem;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.widgets.IIndicatorController;
import mods.railcraft.common.gui.widgets.IndicatorController;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.plugins.forge.OreDictPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileEngravingBench
extends TileMachineItem
implements IPowerReceptor,
ISidedInventory,
IHasWork,
IGuiReturnHandler {
    private static final int PROCESS_TIME = 100;
    private static final int ACTIVATION_POWER = 5;
    private static final int MAX_RECEIVE = 100;
    private static final int MAX_ENERGY = 750;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_RESULT = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    private IInventory invResult = new InventoryMapper(this, 1, 1, false);
    private PowerHandler powerHandler;
    private int progress;
    public int guiEnergy;
    public boolean paused;
    public boolean startCrafting;
    public boolean isCrafting;
    public boolean flippedAxis;
    public String currentEmblem = "";
    private final Set actions = new HashSet();
    private IIndicatorController energyIndicator = new EnergyIndicator();

    public IIndicatorController getEnergyIndicator() {
        return this.energyIndicator;
    }

    public TileEngravingBench() {
        super(2);
        if (RailcraftConfig.machinesRequirePower()) {
            this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
            this.initPowerProvider();
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.ENGRAVING_BENCH;
    }

    private void initPowerProvider() {
        if (this.powerHandler != null) {
            this.powerHandler.configure(1.0f, 100.0f, 5.0f, 750.0f);
            this.powerHandler.configurePowerPerdition(1, 2);
        }
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler != null ? this.powerHandler.getPowerReceiver() : null;
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public Icon getIcon(int side) {
        if (side == ForgeDirection.UP.ordinal()) {
            if (this.flippedAxis) {
                return this.getMachineType().getTexture(6);
            }
            return this.getMachineType().getTexture(1);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("flippedAxis", this.flippedAxis);
        data.func_74757_a("isCrafting", this.isCrafting);
        data.func_74768_a("progress", this.progress);
        data.func_74778_a("currentEmblem", this.currentEmblem);
        if (this.powerHandler != null) {
            this.powerHandler.writeToNBT(data);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.flippedAxis = data.func_74767_n("flippedAxis");
        this.isCrafting = data.func_74767_n("isCrafting");
        this.progress = data.func_74762_e("progress");
        this.currentEmblem = data.func_74779_i("currentEmblem");
        if (this.powerHandler != null) {
            this.powerHandler.readFromNBT(data);
            this.initPowerProvider();
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.flippedAxis);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.flippedAxis = data.readBoolean();
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        GuiPacketType type = GuiPacketType.values()[data.readByte()];
        switch (type) {
            case START_CRAFTING: {
                this.startCrafting = true;
            }
            case NORMAL_RETURN: {
                this.currentEmblem = data.readUTF();
                break;
            }
            case OPEN_UNLOCK: {
                GuiHandler.openGui(EnumGui.ENGRAVING_BENCH_UNLOCK, sender, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                break;
            }
            case OPEN_NORMAL: {
                GuiHandler.openGui(EnumGui.ENGRAVING_BENCH, sender, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                break;
            }
            case UNLOCK_EMBLEM: {
                byte windowId = data.readByte();
                String code = data.readUTF();
                EmblemManager.unlockEmblem(sender, code, windowId);
            }
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) > 64.0) {
            return false;
        }
        GuiHandler.openGui(EnumGui.ENGRAVING_BENCH, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 100;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.field_70331_k)) {
            return;
        }
        if (this.powerHandler != null) {
            this.powerHandler.update();
        }
        if (this.clock % 16 == 0) {
            this.processActions();
        }
        if (this.paused) {
            return;
        }
        if (this.startCrafting) {
            this.startCrafting = false;
            this.isCrafting = true;
        }
        if (this.func_70301_a(1) != null) {
            this.isCrafting = false;
        }
        if (!this.isCrafting) {
            this.progress = 0;
            return;
        }
        ItemStack emblem = this.makeEmblem();
        if (emblem == null) {
            return;
        }
        if (!this.func_94041_b(0, this.func_70301_a(0))) {
            this.progress = 0;
            return;
        }
        if (this.progress >= 100) {
            this.isCrafting = false;
            if (InvTools.isRoomForStack(emblem, this.invResult)) {
                this.func_70298_a(0, 1);
                InvTools.moveItemStack(emblem, this.invResult);
                this.progress = 0;
            }
        } else if (this.powerHandler != null) {
            float energy = this.powerHandler.useEnergy(5.0f, 5.0f, true);
            if (energy >= 5.0f) {
                ++this.progress;
            }
        } else {
            ++this.progress;
        }
    }

    private ItemStack makeEmblem() {
        if (this.currentEmblem == null || this.currentEmblem.equals("")) {
            return null;
        }
        return ItemEmblem.getEmblem(this.currentEmblem);
    }

    @Override
    public boolean hasWork() {
        return this.isCrafting;
    }

    public void setPaused(boolean p) {
        this.paused = p;
    }

    private void processActions() {
        this.paused = false;
        for (IAction action : this.actions) {
            if (action != Actions.PAUSE) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IAction action) {
        this.actions.add(action);
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 1) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        if (stack.field_77994_a <= 0) {
            return false;
        }
        if (OreDictPlugin.isOreType("ingotSteel", stack)) {
            return true;
        }
        if (OreDictPlugin.isOreType("ingotBronze", stack)) {
            return true;
        }
        return Item.field_77717_p.field_77779_bT == stack.field_77993_c;
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase player) {
        super.onBlockPlacedBy(player);
        ForgeDirection facing = MiscTools.getHorizontalSideClosestToPlayer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, player);
        if (facing == ForgeDirection.EAST || facing == ForgeDirection.WEST) {
            this.flippedAxis = true;
        }
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.flippedAxis = !this.flippedAxis;
        this.sendUpdateToClient();
        return true;
    }

    private class EnergyIndicator
    extends IndicatorController {
        private EnergyIndicator() {
        }

        @Override
        protected void refreshToolTip() {
            this.tip.text = String.format("%d MJ", TileEngravingBench.this.guiEnergy);
        }

        @Override
        public int getScaledLevel(int size) {
            float e = Math.min(TileEngravingBench.this.guiEnergy, 750);
            return (int)(e * (float)size / 750.0f);
        }
    }

    public static enum GuiPacketType {
        START_CRAFTING,
        NORMAL_RETURN,
        OPEN_UNLOCK,
        OPEN_NORMAL,
        UNLOCK_EMBLEM;

    }
}

