/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.common.blocks.aesthetics.lamp.BlockStoneLamp;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostBase;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSign;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class PostConnectionHelper {
    public static final Set canConnect = new HashSet();
    public static final Set noConnect = new HashSet();

    public static IPostConnection.ConnectStyle connect(IBlockAccess world, int x1, int y1, int z1, ForgeDirection side) {
        int z2;
        int y2;
        Block block = WorldPlugin.getBlock(world, x1, y1, z1);
        if (block instanceof IPostConnection && ((IPostConnection)block).connectsToPost(world, x1, y1, z1, side) == IPostConnection.ConnectStyle.NONE) {
            return IPostConnection.ConnectStyle.NONE;
        }
        int x2 = MiscTools.getXOnSide(x1, side);
        if (world.func_72799_c(x2, y2 = MiscTools.getYOnSide(y1, side), z2 = MiscTools.getZOnSide(z1, side))) {
            return IPostConnection.ConnectStyle.NONE;
        }
        Block otherBlock = WorldPlugin.getBlock(world, x2, y2, z2);
        ForgeDirection oppositeSide = side.getOpposite();
        try {
            if (otherBlock instanceof IPostConnection) {
                return ((IPostConnection)otherBlock).connectsToPost(world, x2, y2, z2, oppositeSide);
            }
        }
        catch (Error error) {
            Game.logErrorAPI("Railcraft", error, IPostConnection.class);
        }
        try {
            if (otherBlock instanceof IPostConnection) {
                return ((IPostConnection)otherBlock).connectsAt(world, x2, y2, z2, oppositeSide) ? IPostConnection.ConnectStyle.TWO_THIN : IPostConnection.ConnectStyle.NONE;
            }
        }
        catch (Error error) {
            Game.logErrorAPI("Railcraft", error, IPostConnection.class);
        }
        if (otherBlock instanceof BlockPostBase) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        if (noConnect.contains(otherBlock)) {
            return IPostConnection.ConnectStyle.NONE;
        }
        if (canConnect.contains(otherBlock)) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        if (otherBlock instanceof BlockSign) {
            int meta = world.func_72805_g(x2, y2, z2);
            return meta == side.ordinal() ? IPostConnection.ConnectStyle.SINGLE_THICK : IPostConnection.ConnectStyle.NONE;
        }
        if (otherBlock instanceof BlockStoneLamp) {
            return IPostConnection.ConnectStyle.SINGLE_THICK;
        }
        TileEntity otherTile = world.func_72796_p(x2, y2, z2);
        if (otherTile instanceof ISignalTile) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        if (world.isBlockSolidOnSide(x2, y2, z2, oppositeSide, false)) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        return IPostConnection.ConnectStyle.NONE;
    }

    static {
        canConnect.add(Block.field_72014_bd);
        canConnect.add(Block.field_72080_bM);
        canConnect.add(Block.field_72078_bL);
        canConnect.add(Block.field_71946_M);
        canConnect.add(Block.field_72065_as);
        canConnect.add(Block.field_71963_Z);
        noConnect.add(Block.field_71979_v);
        noConnect.add(Block.field_71981_t);
        noConnect.add(Block.field_71940_F);
        noConnect.add(Block.field_71980_u);
        noConnect.add(Block.field_71939_E);
        noConnect.add(Block.field_71986_z);
        noConnect.add(Block.field_71950_I);
        noConnect.add(Block.field_72073_aw);
        noConnect.add(Block.field_72068_bR);
        noConnect.add(Block.field_71941_G);
        noConnect.add(Block.field_71949_H);
        noConnect.add(Block.field_71947_N);
        noConnect.add(Block.field_72047_aN);
        noConnect.add(Block.field_72048_aO);
        noConnect.add(Block.field_72041_aW);
        noConnect.add(Block.field_72039_aU);
        noConnect.add(Block.field_71997_br);
        noConnect.add(Block.field_72061_ba);
        noConnect.add(Block.field_72091_am);
        noConnect.add(Block.field_72013_bc);
        noConnect.add(Block.field_72012_bb);
        noConnect.add(Block.field_71945_L);
    }
}

