/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostBase;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.aesthetics.post.ItemPostMetal;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class BlockPostMetal
extends BlockPostBase {
    public static Icon[] textures;

    public static ItemStack getItem() {
        return BlockPostMetal.getItem(1, 3);
    }

    public static ItemStack getItem(int qty) {
        return BlockPostMetal.getItem(qty, 3);
    }

    public static ItemStack getItem(int qty, int color) {
        Block block = RailcraftBlocks.getBlockPostMetal();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, color);
    }

    private BlockPostMetal(int id, int renderType) {
        super(id, renderType);
        this.func_71864_b("railcraft.post.metal");
        this.func_71884_a(Block.field_71977_i);
    }

    public static Block make(int id, int renderType) {
        BlockPostMetal block = new BlockPostMetal(id, renderType);
        GameRegistry.registerBlock((Block)block, ItemPostMetal.class, (String)block.func_71917_a());
        MinecraftForge.setBlockHarvestLevel((Block)block, (String)"crowbar", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)block, (String)"pickaxe", (int)2);
        ForestryPlugin.addBackpackItem("builder", block);
        return block;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumColor color : EnumColor.values()) {
            list.add(BlockPostMetal.getItem(1, color.ordinal()));
        }
    }

    protected boolean func_71906_q_() {
        return true;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(EnumPost.METAL.getItem());
        return list;
    }

    public void func_94332_a(IconRegister iconRegister) {
        textures = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:post.metal.painted", 16);
    }

    public Icon func_71858_a(int side, int meta) {
        return textures[meta];
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        int c = 15 - colour;
        int meta = world.func_72805_g(x, y, z);
        if (meta != c) {
            world.func_72921_c(x, y, z, c, 3);
            return true;
        }
        return false;
    }
}

