/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import mods.railcraft.client.render.FluidRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.carts.CartContentRenderer;
import mods.railcraft.client.render.carts.RenderCart;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.fluids.tanks.StandardTank;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class CartContentRendererTank
extends CartContentRenderer {
    private final RenderFakeBlock.RenderInfo fillBlock = new RenderFakeBlock.RenderInfo(0.4f, 0.0f, 0.4f, 0.6f, 0.999f, 0.6f);
    private final RenderFakeBlock.RenderInfo bucketSign = new RenderFakeBlock.RenderInfo();
    private static final float FILTER_SCALE_X = 1.38f;
    private static final float FILTER_SCALE_Y = 0.5f;
    private static final float FILTER_SCALE_Z = 0.5f;

    public CartContentRendererTank() {
        this.bucketSign.template = Block.field_71946_M;
        this.bucketSign.texture = new Icon[1];
        this.bucketSign.renderSide[0] = false;
        this.bucketSign.renderSide[1] = false;
        this.bucketSign.renderSide[2] = false;
        this.bucketSign.renderSide[3] = false;
        this.fillBlock.texture = new Icon[6];
    }

    @Override
    public void render(RenderCart renderer, EntityMinecart cart, float light, float time) {
        ItemStack bucket;
        super.render(renderer, cart, light, time);
        EntityCartTank cartTank = (EntityCartTank)cart;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glDisable((int)2896);
        int x = (int)Math.floor(cart.field_70165_t);
        int y = (int)Math.floor(cart.field_70163_u);
        int z = (int)Math.floor(cart.field_70161_v);
        StandardTank tank = cartTank.getTankManager().get(0);
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack != null && fluidStack.amount > 0) {
            Fluid fluid = fluidStack.getFluid();
            int[] displayLists = FluidRenderer.getLiquidDisplayLists(fluidStack);
            if (fluid != null && displayLists != null) {
                ResourceLocation texSheet;
                GL11.glPushMatrix();
                GL11.glPushAttrib((int)8192);
                GL11.glEnable((int)3042);
                GL11.glTranslatef((float)0.0f, (float)0.0625f, (float)0.0f);
                float cap = tank.getCapacity();
                float level = Math.min((float)fluidStack.amount, cap) / cap;
                renderer.func_110776_a(FluidRenderer.getFluidSheet(fluidStack));
                FluidRenderer.setColorForFluidStack(fluidStack);
                GL11.glCallList((int)displayLists[(int)(level * 99.0f)]);
                if (cartTank.isFilling() && (texSheet = FluidRenderer.setupFlowingLiquidTexture(fluidStack, this.fillBlock.texture)) != null) {
                    renderer.func_110776_a(texSheet);
                    RenderFakeBlock.renderBlockForEntity(this.fillBlock, (IBlockAccess)cart.field_70170_p, x, y, z, false, true);
                }
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            }
        }
        if ((bucket = cartTank.getFilterItem()) != null && bucket.field_77993_c > 0) {
            GL11.glPushMatrix();
            GL11.glScalef((float)1.38f, (float)0.5f, (float)0.5f);
            GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
            renderer.func_110776_a(TextureMap.field_110576_c);
            int meta = bucket.func_77960_j();
            for (int pass = 0; pass < bucket.func_77973_b().getRenderPasses(meta); ++pass) {
                Icon texture = bucket.func_77973_b().func_77618_c(meta, pass);
                if (texture == null) continue;
                int color = bucket.func_77973_b().func_82790_a(bucket, pass);
                float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
                float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
                float c3 = (float)(color & 0xFF) / 255.0f;
                float dim = 0.7f;
                GL11.glColor4f((float)(c1 * light * dim), (float)(c2 * light * dim), (float)(c3 * light * dim), (float)1.0f);
                Tessellator tess = Tessellator.field_78398_a;
                tess.func_78380_c(this.bucketSign.template.func_71874_e((IBlockAccess)cart.field_70170_p, x, y, z));
                this.bucketSign.texture[0] = texture;
                RenderFakeBlock.renderBlockForEntity(this.bucketSign, (IBlockAccess)cart.field_70170_p, x, y, z, false, true);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

