/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.client.render.FluidRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.TileTankBase;
import mods.railcraft.common.blocks.machine.beta.TileTankIronValve;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.StandardTank;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderIronTank
extends TileEntitySpecialRenderer {
    private static final RenderFakeBlock.RenderInfo fillBlock = new RenderFakeBlock.RenderInfo();

    public RenderIronTank() {
        float pix = 0.0625f;
        RenderIronTank.fillBlock.minX = 5.0f * pix;
        RenderIronTank.fillBlock.minZ = 5.0f * pix;
        RenderIronTank.fillBlock.maxX = 11.0f * pix;
        RenderIronTank.fillBlock.maxZ = 11.0f * pix;
        RenderIronTank.fillBlock.texture = new Icon[6];
    }

    private void prepFillTexture(FluidStack fluidStack) {
        ResourceLocation texSheet = FluidRenderer.setupFlowingLiquidTexture(fluidStack, RenderIronTank.fillBlock.texture);
        if (texSheet != null) {
            this.func_110628_a(texSheet);
        }
    }

    private float getVerticalScaleSide(TileMultiBlock tile) {
        int y = tile.getPatternPositionY();
        if (!RailcraftConfig.allowTankStacking()) {
            --y;
        }
        return (float)y - 0.3125f;
    }

    private int getTankHeight(TileMultiBlock tile) {
        int height = tile.getPattern().getPatternHeight();
        if (!RailcraftConfig.allowTankStacking()) {
            height -= 2;
        }
        return height;
    }

    private void draw(FluidStack fluidStack) {
        this.preGL();
        FluidRenderer.setColorForFluidStack(fluidStack);
        RenderFakeBlock.renderBlockForEntity(fillBlock, null, 0, 0, 0, false, true);
        this.postGL();
    }

    private void preGL() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private void postGL() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void func_76894_a(TileEntity tile, double x, double y, double z, float f) {
        TileTankBase ironTank;
        FluidStack fluidStack;
        TileTankIronValve valve;
        if (!((TileMultiBlock)tile).isStructureValid()) {
            return;
        }
        if (tile instanceof TileTankIronValve && (valve = (TileTankIronValve)tile).isFilling() && (fluidStack = valve.getFillTank().getFluid()) != null && fluidStack.amount > 0 && fluidStack.getFluid() != null) {
            float yOffset;
            GL11.glPushMatrix();
            if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX(), valve.getPatternPositionY() - 1, valve.getPatternPositionZ()) == 'A') {
                this.prepFillTexture(fluidStack);
                int height = this.getTankHeight(valve);
                yOffset = (float)height / 2.0f;
                float vScale = (float)height - 2.0f;
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset - (float)height + 1.0f), (float)((float)z + 0.5f));
                GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                this.draw(fluidStack);
            } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX() - 1, valve.getPatternPositionY(), valve.getPatternPositionZ()) == 'A') {
                this.prepFillTexture(fluidStack);
                float vScale = this.getVerticalScaleSide(valve);
                yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                GL11.glTranslatef((float)((float)x - 0.5f + 0.3125f), (float)((float)y + yOffset), (float)((float)z + 0.5f));
                GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                this.draw(fluidStack);
            } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX() + 1, valve.getPatternPositionY(), valve.getPatternPositionZ()) == 'A') {
                this.prepFillTexture(fluidStack);
                float vScale = this.getVerticalScaleSide(valve);
                yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                GL11.glTranslatef((float)((float)x + 1.5f - 0.3125f), (float)((float)y + yOffset), (float)((float)z + 0.5f));
                GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                this.draw(fluidStack);
            } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX(), valve.getPatternPositionY(), valve.getPatternPositionZ() - 1) == 'A') {
                this.prepFillTexture(fluidStack);
                float vScale = this.getVerticalScaleSide(valve);
                yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset), (float)((float)z - 0.5f + 0.3125f));
                GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                this.draw(fluidStack);
            } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX(), valve.getPatternPositionY(), valve.getPatternPositionZ() + 1) == 'A') {
                this.prepFillTexture(fluidStack);
                float vScale = this.getVerticalScaleSide(valve);
                yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset), (float)((float)z + 1.5f - 0.3125f));
                GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                this.draw(fluidStack);
            }
            GL11.glPopMatrix();
        }
        if (!(ironTank = (TileTankBase)tile).isMaster() || ironTank.func_70320_p()) {
            return;
        }
        int height = this.getTankHeight(ironTank);
        float yOffset = (float)height / 2.0f;
        float vScale = height - 2;
        float hScale = ironTank.getPattern().getPatternWidthX() - 2;
        TankManager tankManager = ironTank.getTankManager();
        if (tankManager == null) {
            return;
        }
        StandardTank tank = tankManager.get(0);
        if (tank == null) {
            return;
        }
        FluidStack fluidStack2 = tank.getFluid();
        if (fluidStack2 != null && fluidStack2.amount > 0 && fluidStack2.getFluid() != null) {
            this.preGL();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset + 0.01f), (float)((float)z + 0.5f));
            GL11.glScalef((float)hScale, (float)vScale, (float)hScale);
            int[] displayLists = FluidRenderer.getLiquidDisplayLists(fluidStack2);
            if (displayLists != null) {
                GL11.glPushMatrix();
                float cap = tank.getCapacity();
                float level = Math.min((float)fluidStack2.amount, cap) / cap;
                this.func_110628_a(FluidRenderer.getFluidSheet(fluidStack2));
                FluidRenderer.setColorForFluidStack(fluidStack2);
                GL11.glCallList((int)displayLists[(int)(level * 99.0f)]);
                GL11.glPopMatrix();
            }
            this.postGL();
        }
    }
}

